<?php

namespace Rubicore\Saml;

use \WP_REST_Request, \WP_User;

final class Saml_Controller
{

	function __construct()
	{
		$this->routes();
	}

	private function routes(): void
	{
		$api = new \Rubicore\Core\Api_Helper('rubicore/saml/v1');

		$api->add_route('login', 'POST', function (WP_REST_Request $req, WP_User $user) : void {
			$auth = new \SimpleSAML\Auth\Simple('default-sp');
			$redirectUrl = $_POST['redirectUrl'];

			if ($auth->isAuthenticated()) {
				header("Location: {$redirectUrl}", true, 302);
				exit;
			}

			$auth->requireAuth();
		}, array(
			'auth_required' => false,
			'args' => array(
				'redirectUrl' => array('type' => 'string', 'required' => true)
			)
		));



		$api->add_route('logout', 'POST', function (WP_REST_Request $req, WP_User $user) : void {
			$auth = new \SimpleSAML\Auth\Simple('default-sp');
			//$redirectUrl = "{$_POST['redirectUrl']}?logged_out=true";
			$redirectUrl = "http://saml02.alingsas.se/kommunportalen/logout";

			if ($auth->isAuthenticated()) {
				$session = \SimpleSAML\Session::getSessionFromRequest();
				$session_id = $session->getSessionId();
				$token_repo = new \Rubicore\Core\Token_Repository();
				$current_token = $token_repo->get_by_ref($session_id);

				if ($current_token) {
					$token_repo->delete($current_token->id);
				}

				$auth->logout([
					'ReturnTo' => $redirectUrl
				]);
			}

			header("Location: {$redirectUrl}", true, 302);
		}, array(
			'auth_required' => false,
			'args' => array(
				'redirectUrl' => array('type' => 'string', 'required' => true)
			)
		));



		$api->add_route('token', 'GET', function (WP_REST_Request $req, WP_User $user) : ?\Rubicore\Core\Token_Model {
			$auth = new \SimpleSAML\Auth\Simple('default-sp');

			if ($auth->isAuthenticated() === false) {
				return null;
			}

			$session = \SimpleSAML\Session::getSessionFromRequest();
			$session_id = $session->getSessionId();
			$token_repo = new \Rubicore\Core\Token_Repository();

			$current_token = $token_repo->get_by_ref($session_id);

			if ($current_token) {
				return \Rubicore\Core\Token_Transformer::transform_out($current_token);
			}

			$attributes = $auth->getAttributes();
			@$uid = $attributes['cn'][0];

			if (!$uid) {
				\Rubicore\Core\Response_Helper::die('Something went wrong, please try again or contact sysadmin.');
			}

			$user = get_user_by('login', $uid);

			if (!$user) {
				\Rubicore\Core\Response_Helper::die('Something went wrong, please try again or contact sysadmin.');
			}

			$token = $token_repo->create($user->ID, 'web', $session_id);

			return \Rubicore\Core\Token_Transformer::transform_out($token);

		}, array(
			'auth_required' => false
		));
	}
}
