<?php if (!defined('ABSPATH')) {
	exit;
}

/*
Plugin Name: Rubicore SAML
Plugin URI:
Description: SAML Login plugin for Rubicore framework using simplesaml
Version: 0.0.1
Author: Knowe AB
Author URI: https://knowe.se
Text Domain: RBC
*/


@ include_once "/var/simplesamlphp/lib/_autoload.php";

function RUBICORE_SAML_check_dependencies(): void
{
	if (!is_plugin_active('rubicore-core/rubicore-core.php') && current_user_can('activate_plugins')) {
		deactivate_plugins(plugin_basename(__FILE__, true));
		wp_die('Sorry, but Rubicore SAML plugin requires the Rubicore Core plugin to be installed and active. <br><a href="' . admin_url('plugins.php') . '">&laquo; Return to Plugins</a>');
	}

	if (!class_exists('\SimpleSAML\Auth\Simple')) {
		deactivate_plugins(plugin_basename(__FILE__, true));
		wp_die('Sorry, unable to find SimpleSAML installation. <br><a href="' . admin_url('plugins.php') . '">&laquo; Return to Plugins</a>');
	}
}

register_activation_hook(__FILE__, 'RUBICORE_SAML_check_dependencies');

define('RUBICORE_SAML_ROOT_DIR', WP_PLUGIN_DIR . '/rubicore-saml');

add_action('rubicore_init', function () {
	Rubicore\Core\Autoloader::register_autoloader(RUBICORE_SAML_ROOT_DIR, 'Rubicore\\Saml\\');

	new Rubicore\Saml\Saml_Controller();
});


add_action('admin_init', function () {
	RUBICORE_SAML_check_dependencies();
});
