<?php if (!defined('ABSPATH')) {
	exit;
}

/*
Plugin Name: Rubicore Mail
Plugin URI:
Description: Mail plugin for Rubicore framework. This plugin is made specific for Alingsås Kommun.
Version: 1.0.4
Author: Knowe AB
Author URI: https://knowe.se
Text Domain: Rubicore
*/


function RUBICORE_Mail_check_dependencies(): void
{
	if (!is_plugin_active('rubicore-core/rubicore-core.php') && current_user_can('activate_plugins')) {
		deactivate_plugins(plugin_basename(__FILE__, true));
		wp_die('Sorry, but Rubicore Mail plugin requires the Rubicore Core plugin to be installed and active. <br><a href="' . admin_url('plugins.php') . '">&laquo; Return to Plugins</a>');
	}

	if (is_null(constant('RUBICORE_MAIL_SETTINGS'))) {
		deactivate_plugins(plugin_basename(__FILE__, true));
		wp_die("
			Missing SMTP settings, add settings to wp-config.php.
			<pre>
				define('RUBICORE_MAIL_SETTINGS', array(
					'host' => '',
					'port' => 25,
					'auth' => false,
					'tls' => false,
					'secure' => 'none',
					'charset' => 'utf-8',
					'username' => '',
					'password' => '',
					'from_address' => '',
					'from_name' => ''
				));
			</pre>
			<br><a href='{admin_url('plugins.php')}
			'>&laquo; Return to Plugins</a>");
	}
}

register_activation_hook(__FILE__, 'RUBICORE_Mail_check_dependencies');

define('RUBICORE_MAIL_ROOT_DIR', WP_PLUGIN_DIR . '/rubicore-mail');

add_action('rubicore_init', function () {
	Rubicore\Core\Autoloader::register_autoloader(RUBICORE_MAIL_ROOT_DIR, 'Rubicore\\Mail\\');

	require RUBICORE_MAIL_ROOT_DIR . '/plugins/mustache.php-2.14.2/src/Mustache/Autoloader.php';
	\Mustache_Autoloader::register();
});


add_action('admin_init', function () {
	RUBICORE_Mail_check_dependencies();
});

add_action('phpmailer_init', function (PHPMailer\PHPMailer\PHPMailer $mailer) {
	$settings = constant('RUBICORE_MAIL_SETTINGS');

	$mailer->IsSMTP();
	$mailer->Host = $settings['host'];
	$mailer->Port = $settings['port'];
	$mailer->SMTPDebug = false;
	$mailer->SMTPAuth = $settings['auth'];
	$mailer->SMTPAutoTLS = $settings['tls'];
	$mailer->SMTPSecure = $settings['secure'];
	$mailer->CharSet  = $settings['charset'];

	$mailer->Username = $settings['username'];
	$mailer->Password = $settings['password'];
	$mailer->setFrom($settings['from_address'], $settings['from_name']);

	return $mailer;
});
