<?php

namespace Rubicore\Mail;

final class Template_Helper
{
	public static function render(string $template_name, string $template_dir, array $context)
	{
		$mustache = new \Mustache_Engine(array(
			'loader' => new \Mustache_Loader_FilesystemLoader($template_dir),
			'charset' => 'UTF-8',
			'strict_callables' => true,
		));

		$tpl = $mustache->loadTemplate($template_name);

		return $tpl->render($context);
	}
}
