<?php

namespace Rubicore\Mail;

use \WP_REST_Request, \WP_User;
use \Rubicore\Core\Response_Helper;
use \Rubicore\Core\Request_Helper;


final class Hook_Controller
{

	function __construct()
	{
		$this->register_hooks();
	}

	private function register_hooks() : void
	{
		add_action('rubicore_core_post_create', function (array $data) {

		});


		do_action('rubicore_core_course_approved', function (array $data) : void {
			$post = \Rubicore\Core\Post_Service::get_by_slug($data['post_id'], 'course');
			$user = \Rubicore\Core\User_Service::get_by_identifier($data['user_id']);

			$email = [$user->email];

			$body = [
				[
					'image_url' => "https://api-prd-intranet01.alingsas.se/wp-content/uploads/{$post->media->filename}",
					'type' => 'card',
					'title' => $post->title,
					'text' => $post->excerpt,
					'button_text' => 'VISA INLÄGG',
					'button_href' => "https://prd-intranet01.alingsas.se/kurs/{$post->slug}"
				]
			];

			Mail_Helper::send_mail($email, "Antagen på kurs: $post->title", $body);
		});
	}
}
