<?php

namespace Rubicore\Mail;

use \Rubicore\Core\Response_Helper;

final class Mail_Helper
{
	public static function send_mail(array $to, string $subject, array $body) : void {
		global $phpmailer;

		wp_mail($to, $subject, Template_Helper::generate_template($body), [
			'Content-Type: text/html; charset=UTF-8'
		]);

		if (isset($phpmailer) && $phpmailer->ErrorInfo) {
			Response_Helper::die($phpmailer->ErrorInfo);
		}
	}
}
