<?php

namespace Rubicore\Ldap;

final class User_Transformer
{
	public static function transform_out($wp_user, array $ldap_data): User_Model
	{
		$model = new User_Model();

		$model->id = $wp_user ? $wp_user->ID : null;
		$model->wp_user_login = $wp_user ? $wp_user->user_login : null;
		$model->wp_user_email = $wp_user ? $wp_user->user_email : null;
		$model->wp_first_name = $wp_user ? $wp_user->first_name : null;
		$model->wp_last_name = $wp_user ? $wp_user->last_name : null;
		$model->description = $wp_user ? $wp_user->description : '';

		$model->uid = $ldap_data['uid'];
		$model->firstName = $ldap_data['first_name'];
		$model->lastName = $ldap_data['last_name'];
		$model->email = $ldap_data['email'];
		$model->groups = array_map(fn($val) : Group_Model => Group_Transformer::transform_out($val), $ldap_data['groups']);
		$model->groupsMain = array_map(fn($val) : Group_Model => Group_Transformer::transform_out($val), $ldap_data['groups_main']);
		$model->groupsMainString = $ldap_data['groups_main_str'];
		$model->jobs = $ldap_data['jobs'];
		$model->pidJobCode = $ldap_data['pid_job_code'];
		$model->phone = $ldap_data['phone'];
		$model->mobile = $ldap_data['mobile'];

		return $model;
	}

	public static function transform_response_out(array $added, array $removed): User_Response_Model
	{
		$model = new User_Response_Model();

		$model->added = $added;
		$model->removed = $removed;

		return $model;
	}
}
