<?php

namespace Rubicore\Ldap;

final class Group_Service
{
	private Group_Repository $group_repo;

	public function __construct()
	{
		$this->group_repo = new Group_Repository();
	}

	public function list() : array
	{
		$groups = $this->group_repo->list();

		return array_map(fn($group) : Group_Model => Group_Transformer::transform_out($group), $groups);
	}

	public function list_internal(int $category_id): array
	{
		$groups_internal = $this->group_repo->get_all_nodes_from_category($category_id);

		return array_map(fn ($group): Group_Model => Group_Transformer::transform_out($group), $groups_internal);
	}

	public function sync_all(int $category_id) : Group_Response_Model
	{
		// Get groups from Ldap, and create/update internal groups
		$groups_ldap = $this->list();
		$groups_added = $this->group_repo->create($groups_ldap, $category_id);
		$this->group_repo->update_parents($groups_ldap);

		// Get internal groups and run cleanup to remove unused groups
		$groups_internal = $this->list_internal($category_id);
		$groups_removed = $this->cleanup($groups_ldap, $groups_internal);

		// Prepare and return response model
		return Group_Transformer::transform_response_out(array_map(fn($group) : Group_Model => Group_Transformer::transform_out($group), $groups_added), $groups_removed);
	}

	public function cleanup(array $groups_ldap, array $groups_internal) : array
	{
		$diffs = array_diff(array_column($groups_internal, 'id'), array_column($groups_ldap, 'id'));
		$to_be_removed = [];

		foreach ($diffs as $key => $value) {
			$to_be_removed[] = $groups_internal[$key];
			$this->group_repo->remove_group($groups_internal[$key]);
		}

		return $to_be_removed;
	}
}
