<?php

namespace Rubicore\Ldap;

final class Ldap_Helper {

	public static function search(?string $search_query, ?string $base = null)
	{
		$options = constant('RUBICORE_LDAP_SETTINGS');
		$connect = ldap_connect($options['host'], $options['port']) or \Rubicore\Core\Response_Helper::die("Could not connect to LDAP server.", 500);
		ldap_set_option($connect, LDAP_OPT_PROTOCOL_VERSION, 3);

		if ($options['tsl']) {
			ldap_start_tls($connect);
		}

		$bind = @ldap_bind($connect, $options['username'], $options['password']) or \Rubicore\Core\Response_Helper::die("Could not connect to LDAP server.", 500);;

		if (!$bind) {
			$errno = ldap_errno($connect);

			if ($errno) {
				\Rubicore\Core\Response_Helper::die($errno, 500);
			}
		}

		$result = null;

		if (!is_null($search_query)) {
			$read = ldap_search(
				$connect,
				$base != null ? $base : $options['base'],
				$search_query
			);

			$result = ldap_get_entries($connect, $read);
		}

		ldap_close($connect);

		return $result;
	}



	public static function get_single_value($obj, $key, $fallback)
	{
		if (isset($obj[$key])) {
			if (isset($obj[$key]['0'])) {
				return $obj[$key]['0'];
			}

			return $fallback;
		}

		return $fallback;
	}

	public static function get_multi_value($obj, $key, $fallback)
	{
		if (isset($obj[$key])) {
			return $obj[$key];
		}

		return $fallback;
	}

}
