<?php

namespace Rubicore\Ldap;

use \WP_REST_Request,
	\WP_User;

final class User_Controller
{
	private User_Service $user_service;

	function __construct()
	{

		$this->user_service = new User_Service();
		$this->routes();
	}

	private function routes(): void
	{
		$api = new \Rubicore\Core\Api_Helper('rubicore/ldap/v1');

		$api->add_route('sync/user/(?P<uid>[^/]+?)', 'POST', function (WP_REST_Request $req, WP_User $user) : User_Response_Model {
			\Rubicore\Core\User_Helper::allowed_to('ldap_handle', $user);

			$uid = $req->get_param('uid');
			$user = $this->user_service->get($uid);

			if (is_null($user)) {
				\Rubicore\Core\Response_Helper::not_found('No user found with specified ID.');
			}

			return $this->user_service->sync([$user]);
		});

		$api->add_route('sync/users', 'POST', function (WP_REST_Request $req, WP_User $user) : User_Response_Model {
			\Rubicore\Core\User_Helper::allowed_to('ldap_handle', $user);

			$users = $this->user_service->list();
			return $this->user_service->sync($users);
		});

		$api->add_route('clear/users', 'POST', function (WP_REST_Request $req, WP_User $user): void {
			\Rubicore\Core\User_Helper::allowed_to('ldap_handle', $user);

			$users = $this->user_service->list();
			$this->user_service->clear_inactive($users);
		});
	}
}
