<?php

namespace Rubicore\Ldap;

final class Group_Transformer
{
	public static function transform_out(array $data) : Group_Model {
		$model = new Group_Model();

		$model->id = $data['id'];
		$model->parent = isset($data['parent']) ? $data['parent'] : null;
		$model->name = $data['name'];
		$model->node_id = isset($data['node_id']) ? $data['node_id'] : null;
		$model->category_id = isset($data['category_id']) ? $data['category_id'] : null;

		return $model;
	}

	public static function transform_response_out(array $added, array $removed): Group_Response_Model
	{
		$model = new Group_Response_Model();

		$model->added = $added;
		$model->removed = $removed;

		return $model;
	}
}
