<?php

namespace Rubicore\Ldap;

use \WP_REST_Request,
	\WP_User;


final class Group_Controller {

	private Group_Service $group_service;

	function __construct() {
		$this->group_service = new Group_Service();

		$this->routes();
	}

	private function routes(): void
	{
		$api = new \Rubicore\Core\Api_Helper('rubicore/ldap/v1');

		$api->add_route('group', 'GET', function (WP_REST_Request $req, WP_User $user) : array {
			\Rubicore\Core\User_Helper::allowed_to('ldap_handle', $user);

			$group_service = new Group_Service();

			return $group_service->list();
		});

		$api->add_route('sync/groups', 'POST', function (WP_REST_Request $req, WP_User $user) : Group_Response_Model {
			\Rubicore\Core\User_Helper::allowed_to('ldap_handle', $user);

			$body = \Rubicore\Core\Request_Helper::get_body($req);
			$category_id = $body->categoryId;

			if ($category_id) {
				$category = (new \Rubicore\Core\Category_Repository())->get_by_id($category_id);

				if (!$category) {
					\Rubicore\Core\Response_Helper::not_found('No category found with provided id.');
				}
			}

			return $this->group_service->sync_all($category_id);
		}, array(
			'args' => array(
				'categoryId' => array(
					'type' => 'int',
					'required' => false,
					'minumum' => 1
				)
			)
		));

	}
}
