<?php

namespace Rubicore\Ldap;

use \WP_REST_Request, \WP_User;

final class Group_Controller {

	function __construct() {
		$this->routes();
	}

	private function routes(): void
	{
		$api = new \Rubicore\Core\Api_Helper('rubicore/ldap/v1');

		$api->add_route('sync/groups', 'POST', function (WP_REST_Request $req, WP_User $user) : void {
			\Rubicore\Core\User_Helper::allowed_to('ldap_handle', $user);

			$group_repo = new Group_Repository();
			$groups = $group_repo->get();
			$groups = array_map(fn ($val): Group_Model => Group_Transformer::transform_out($val), $groups);

			$body = \Rubicore\Core\Request_Helper::get_body($req);

			if ($body->categoryId) {
				$category = (new \Rubicore\Core\Category_Repository())->get_by_id($body->categoryId);

				if (!$category) {
					\Rubicore\Core\Response_Helper::not_found('No category found with provided id.');
				}
			}

			$group_repo->create($groups, $body->categoryId);
			$group_repo->update_parents($groups);
		}, array(
			'args' => array(
				'categoryId' => array(
					'type' => 'int',
					'required' => false,
					'minumum' => 1
				)
			)
		));

	}
}
