<?php if (!defined('ABSPATH')) {
	exit;
}

/*
Plugin Name: Rubicore LDAP
Plugin URI:
Description: LDAP plugin for Rubicore framework
Version: 0.7.1
Author: Knowe AB
Author URI: https://knowe.se
Text Domain: RBC
*/

function RUBICORE_LDAP_check_dependencies (): void {
 	if (!function_exists('ldap_connect') && current_user_can('activate_plugins')) {
		deactivate_plugins(plugin_basename(__FILE__, true));
		wp_die('Sorry, but Rubicore LDAP plugin requires the php ldap extension to be enabled. <br><a href="' . admin_url('plugins.php') . '">&laquo; Return to Plugins</a>');
	}

	if (!is_plugin_active('rubicore-core/rubicore-core.php') && current_user_can('activate_plugins')) {
		deactivate_plugins(plugin_basename(__FILE__, true));
		wp_die('Sorry, but Rubicore LDAP plugin requires the Rubicore Core plugin to be installed and active. <br><a href="' . admin_url( 'plugins.php' ) . '">&laquo; Return to Plugins</a>');
	}

	if (is_null(constant('RUBICORE_LDAP_SETTINGS'))) {
		deactivate_plugins(plugin_basename(__FILE__, true));
		wp_die("
			Missing LDAP settings, add settings to wp-config.php.
			<pre>
				define('RUBICORE_LDAP_SETTINGS', array(
					'host' => '',
					'port' => 636,
					'base' => '',
					'tsl' => true,
					'username' => '',
					'password' => ''
				));
			</pre>
			<br><a href='{admin_url('plugins.php')}
			'>&laquo; Return to Plugins</a>");
	}
}

register_activation_hook(__FILE__, 'RUBICORE_LDAP_check_dependencies');

define('RUBICORE_LDAP_ROOT_DIR', WP_PLUGIN_DIR . '/rubicore-ldap');

add_action('rubicore_init', function () {
	Rubicore\Core\Autoloader::register_autoloader(RUBICORE_LDAP_ROOT_DIR, 'Rubicore\\Ldap\\');

	new Rubicore\Ldap\Group_Controller();
	new Rubicore\Ldap\User_Controller();

	add_filter('rubicore_capability_list', function ($capability_list) {
		$custom = [
			['group' => 'custom_ldap', 'key' => 'ldap_handle', 'desc' => 'Hantera LDAP (CRON)']
		];

		return array_merge($capability_list, $custom);
	});
});


add_action('admin_init', function () {
	RUBICORE_LDAP_check_dependencies();
});
