<?php

namespace Rubicore\Ldap;

use \WP_REST_Request, \WP_User;

final class User_Controller
{

	function __construct()
	{
		$this->routes();
	}

	private function routes(): void
	{
		$api = new \Rubicore\Core\Api_Helper('rubicore/ldap/v1');

		$api->add_route('sync/users', 'POST', function (WP_REST_Request $req, WP_User $user): void {
			\Rubicore\Core\User_Helper::allowed_to('ldap_handle', $user);

			$user_repo = new User_Repository();
			$users = $user_repo->get();
			$users = array_map(fn ($val): User_Model => User_Transformer::transform_out($val), $users);
			$last_update = \Rubicore\Core\Date_Helper::gmt_now(2);
			update_option('last_ldap_user_update', $last_update);

			foreach ($users as $user) {
				$user_row = get_user_by('login', $user->uid);
				$new_user = empty($user_row);

				$userdata = array(
					'user_login' => $user->uid,
					'user_nicename' => $user->uid,
					'user_email' => $user->email,
					'display_name' => $user->firstName . ' ' . $user->lastName,
					'nickname' => $user->uid,
					'first_name' => $user->firstName,
					'last_name' => $user->lastName,
					'meta_input' => [
						'phone1' => $user->mobile,
						'phone2' => $user->phone,
						'last_ldap_update' => $last_update,
						'disable_login' => false
					]
				);

				if (!empty($user_row)) {
					$userdata['ID'] = $user_row->ID;
				} else {
					$userdata['user_pass'] = wp_hash_password('test');
					$userdata['role'] = 'rubicore-user';
				}

				$user_id = wp_insert_user($userdata);

				if ($new_user) {
					$this->update_groups($user_id, $user->groupsMain, true);
					$this->update_groups($user_id, $user->groups, false);
					$this->update_jobs($user_id, $user->jobs);
					continue;
				}

				$this->remove_main_groups($user_id);
				$this->update_groups($user_id, $user->groupsMain, true);
				$this->update_jobs($user_id, $user->jobs);
			}
		});


		$api->add_route('clear/users', 'POST', function (WP_REST_Request $req, WP_User $user): void {
			\Rubicore\Core\User_Helper::allowed_to('ldap_handle', $user);

			$last_update = get_option('last_ldap_user_update');
			$user_repo = new User_Repository();

			$users = $user_repo->get_old_users($last_update);

			foreach ($users as $user) {
				$userdata = array(
					'ID' => $user->ID,
					'user_nicename' => '',
					'user_email' => '',
					'display_name' => 'Inaktiv',
					'first_name' => 'Inaktiv',
					'last_name' => 'Inaktiv',
					'meta_input' => [
						'phone1' => '',
						'phone2' => '',
						'last_ldap_update' => '',
						'disable_login' => true
					]
				);

				wp_insert_user($userdata);
			}
		});
	}

	private function update_jobs($user_id, $jobs)
	{
		$node_repo = new \Rubicore\Core\Node_Repository();
		$category_node_repo = new \Rubicore\Core\Category_Node_Repository();
		$user_category_repo = new \Rubicore\Core\User_Category_Repository();
		$user_repo = new User_Repository();

		$user_repo->remove_old_jobs($user_id);

		foreach ($jobs as $jobs) {
			$node = $node_repo->get_by_value($jobs);

			if (!$node) {
				continue;
			}

			$category_nodes = $category_node_repo->get_by_node_id($node->id);

			foreach ($category_nodes as $cn) {
				$user_category_repo->add($user_id, $cn->category_id);
			}
		}
	}

	private function update_groups(int $user_id, array $groups, bool $is_main): void
	{
		$node_repo = new \Rubicore\Core\Node_Repository();
		$user_node_repo = new \Rubicore\Core\User_Node_Repository();

		foreach ($groups as $group) {
			$node = $node_repo->get_by_value($group);

			if (!$node) {
				continue;
			}

			if (!$user_node_repo->get_by_id($user_id, $node->id)) {
				$user_node_repo->add($user_id, $node->id, $is_main);
			}
		}
	}

	private function remove_main_groups(int $user_id): void
	{
		$user_repo = new User_Repository();
		$user_node_repo = new \Rubicore\Core\User_Node_Repository();
		$nodes = $user_repo->get_main_nodes($user_id, 'cidorganizations');

		foreach ($nodes as $node) {
			$user_node_repo->remove($user_id, $node->node_id);
		}
	}
}
