<?php

namespace Rubicore\Ldap;

final class Group_Helper {

	public static function parse_groups($cid_organization_strings)
	{
		if (!is_array($cid_organization_strings)) {
			$cid_organization_strings = [$cid_organization_strings];
		}

		$all_groups = array();

		// Process each incoming strings
		foreach ($cid_organization_strings as $key => $cid_organization_string) {
			if ($key === 'count') {
				continue;
			}
			// Split string to an array and remove dangling empty values
			$groups = array_filter(explode('#', $cid_organization_string), fn ($val) => $val != ';');

			// Explode and map the values
			$groups = array_map(fn ($val) => explode(';', $val), $groups);

			// Map even more and add parent
			$groups = array_map(function ($val, $index) use ($groups) {
				return array(
					"id" => $val[1],
					"name" => $val[0],
					"parent" => $index == 0 ? null : $groups[$index - 1][1]
				);
			}, $groups, array_keys($groups));

			$groups = array_filter($groups, fn ($val) => $val['id'] !== null);

			// Push all groups to the same array
			array_push($all_groups, ...$groups);
		}


		// Remove duplicates
		$all_groups = array_reduce($all_groups, function ($acc, $curr) {
			$added = array_search($curr['id'], array_column($acc, 'id'));

			return $added === false ? array(...$acc, $curr) : $acc;
		}, array());


		return $all_groups;
	}
}
