<?php

namespace Rubicore\Ldap;

use Rubicore\Core\Db_Helper;

final class User_Repository
{
	public function get()
	{
		$users = Ldap_Helper::search("(&(cn=*)(|(pidcategory=Emp)(pidcategory=Ext)))");
		$all_users = array();

		foreach ($users as $user) {
			$uid = Ldap_Helper::get_single_value($user, 'uid', null);

			if (!$uid) {
				continue;
			}

			$groups = Ldap_Helper::get_multi_value($user, 'cidorganizationstringmv', array());
			$groups_main = Ldap_Helper::get_multi_value($user, 'cidorganizationstringmain', array());

			$groups = Group_Helper::parse_groups($groups);
			$groups_main = Group_Helper::parse_groups($groups_main);

			$groups = array_filter($groups, function ($val) use($groups_main) {
				$added = array_search($val['id'], array_column($groups_main, 'id'), true);

				return !is_numeric($added);
			});

			$jobs = Ldap_Helper::get_single_value($user, 'pidjobcode', array());

			$all_users[] = array(
				'uid' => $uid,
				'groups' => $groups,
				'groups_main' => $groups_main,
				'first_name' => Ldap_Helper::get_single_value($user, 'givenname', ''),
				'last_name' => Ldap_Helper::get_single_value($user, 'sn', ''),
				'email' => Ldap_Helper::get_single_value($user, 'mail', ''),
				'jobs' => is_array($jobs) ? $jobs : [$jobs],
				'mobile' => Ldap_Helper::get_single_value($user, 'akmobilenumber', ''),
				'phone' => Ldap_Helper::get_single_value($user, 'akphonenumber', '')
			);
		}

		unset($user);

		return $all_users;
	}


	public function get_main_nodes(int $user_id, string $type) : array
	{
		$user_node_table = Db_Helper::table('user_node');
		$category_table = Db_Helper::table('category');
		$category_node_table = Db_Helper::table('category_node');
		$node_table = Db_Helper::table('node');

		return Db_Helper::get_rows("
			SELECT * FROM {$category_table} AS c

			INNER JOIN {$category_node_table} AS cn
			ON cn.category_id = c.id

			INNER JOIN {$node_table} AS n
			ON n.id = cn.node_id

			INNER JOIN {$user_node_table} AS un
			ON un.node_id = n.id
			AND un.user_id = %d
			AND un.main = true

			WHERE c.type = %s
		", [$user_id, $type]);
	}

	public function remove_old_jobs(int $user_id)
	{
		$category_table = Db_Helper::table('category');
		$user_category_repo = new \Rubicore\Core\User_Category_Repository();

		$categories = Db_Helper::get_rows("
			SELECT * FROM {$category_table} AS c
			WHERE c.type = 'pidjob'
		");

		foreach ($categories as $category) {
			$user_category_repo->remove($user_id, $category->id);
		}
	}
}
