<?php

namespace Rubicore\Ldap;

use \WP_REST_Request, \WP_User;

final class User_Controller
{

	function __construct()
	{
		$this->routes();
	}

	private function routes() : void
	{
		$api = new \Rubicore\Core\Api_Helper('rubicore/ldap/v1');

		$api->add_route('sync/users', 'POST', function (WP_REST_Request $req, WP_User $user) : void {
			$user_repo = new User_Repository();
			$users = $user_repo->get();
			$users = array_map(fn ($val): User_Model => User_Transformer::transform_out($val), $users);

			foreach ($users as $user) {
				$user_row = get_user_by('login', $user->uid);
				$new_user = empty($user_row);

				$userdata = array(
					'user_login' => $user->uid,
					'user_nicename' => $user->uid,
					'user_email' => $user->email,
					'display_name' => $user->firstName . ' ' . $user->lastName,
					'nickname' => $user->uid,
					'first_name' => $user->firstName,
					'last_name' => $user->lastName,
					'meta_input' => [
						'phone1' => $user->mobile,
						'phone2' => $user->phone
					]
				);

				if (!empty($user_row)) {
					$userdata['ID'] = $user_row->ID;
				} else {
					$userdata['user_pass'] = wp_hash_password('test');
					$userdata['role'] = 'rubicore-user';
				}

				$user_id = wp_insert_user($userdata);

				if ($new_user) {
					$this->update_groups($user_id, $user->groupsMain, true);
					$this->update_groups($user_id, $user->groups, false);
					continue;
				}

				$this->remove_main_groups($user_id);
				$this->update_groups($user_id, $user->groupsMain, true);
			}
		});

	}

	private function update_groups(int $user_id, array $groups, bool $is_main) : void
	{
		$node_repo = new \Rubicore\Core\Node_Repository();
		$user_node_repo = new \Rubicore\Core\User_Node_Repository();

		foreach ($groups as $group) {
			$node = $node_repo->get_by_value($group);

			if (!$node) {
				continue;
			}

			if (!$user_node_repo->get_by_id($user_id, $node->id)) {
				$user_node_repo->add($user_id, $node->id, $is_main);
			}
		}
	}

	private function remove_main_groups(int $user_id) : void
	{
		$user_repo = new User_Repository();
		$user_node_repo = new \Rubicore\Core\User_Node_Repository();
		$nodes = $user_repo->get_main_nodes($user_id, 'cidorganizations');

		foreach ($nodes as $node) {
			$user_node_repo->remove($user_id, $node->node_id);
		}
	}
}
