<?php

final class RUBICORE_Ldap {



	private static function search($search_query) {

		$options = get_option('ldap');

		$connect = ldap_connect($options['host'], $options['port']) or die("Could not connect to LDAP server.");
		ldap_set_option($connect, LDAP_OPT_PROTOCOL_VERSION, 3);

		if ($options['tsl']) {
			ldap_start_tls($connect);
		}

		$bind = ldap_bind($connect, $options['user'], $options['password']);

		if (!$bind) {
			$errno = ldap_errno($connect);

			if ($errno) {
				RUBICORE_Utils::die($errno);
			}

		}

		$read = ldap_search(
			$connect,
			$options['base'],
			$search_query
		);

		$result = ldap_get_entries($connect, $read);
		ldap_close($connect);

		return $result;
	}



	private static function get_ldap_value($obj, $key, $fallback) {
		if (isset($obj[$key])) {
			if (isset($obj[$key][0])) {
				return $obj[$key][0];
			}

			return $fallback;
		}

		return $fallback;
	}



	public static function get_all_users() {
		$users = self::search("(&(cn=*)(|(pidcategory=Emp)(pidcategory=Ext)))");
		$all_users = array();

		foreach ($users as $user) {
			$uid = self::get_ldap_value($user, 'uid', null);

			if (!$uid) {
				continue;
			}

			$groups = self::get_ldap_value($user, 'cidorganizationstringmv', array());
			$groups_main = self::get_ldap_value($user, 'cidorganizationstringmain', array());
			$jobs = self::get_ldap_value($user, 'pidjobcode', array());
			$jobs = is_array($jobs) ? $jobs : [$jobs];
			$jobs = array_map(function ($val) {
				return array('id' => $val);
			}, $jobs);

			$all_users[] = array(
				'uid' => $uid,
				'groups' => self::get_user_groups($groups),
				'groups_main' => self::get_user_groups($groups_main),
				'first_name' => self::get_ldap_value($user, 'givenname', ''),
				'last_name' => self::get_ldap_value($user, 'sn', ''),
				'email' => self::get_ldap_value($user, 'mail', ''),
				'jobs' => $jobs
			);


		}

		unset($user);

		return $all_users;
	}


	public static function get_all_groups() {
		$users = self::search("(&(cn=*)(|(pidcategory=Emp)(pidcategory=Ext)))");
		$all_groups = array();

		foreach ($users as $user) {
			$groups = self::get_ldap_value($user, 'cidorganizationstringmv', array());
			$groups_arr = self::get_user_groups($groups);
			array_push($all_groups, ...$groups_arr);
		}

		unset($user);

		$all_groups = array_reduce($all_groups, function ($acc, $curr) {
			$added = array_search($curr['id'], array_column($acc, 'id'));

			return $added === false ? array(...$acc, $curr) : $acc;
		}, array());

		return $all_groups;
	}



	private static function get_user_groups($cid_organization_strings) {
		if (!is_array($cid_organization_strings)) {
			$cid_organization_strings = [$cid_organization_strings];
		}

		$all_groups = array();

		// Process each incoming strings
		foreach ($cid_organization_strings as $key => $cid_organization_string) {
			if ($key === 'count') {
				continue;
			}
			// Split string to an array and remove dangling empty values
			$groups = array_filter(explode('#', $cid_organization_string), fn($val) => $val != ';');

			// Explode and map the values
			$groups = array_map(fn($val) => explode(';', $val), $groups);

			// Map even more and add parent
			$groups = array_map(function ($val, $index) use ($groups) {
				return array(
					"id" => $val[1],
					"name" => $val[0],
					"parent" => $index == 0 ? null : $groups[$index - 1][1]
				);
			}, $groups, array_keys($groups));

			$groups = array_filter($groups, fn($val) => $val['id'] !== null);

			// Push all groups to the same array
			array_push($all_groups, ...$groups);
		}


		// Remove duplicates
		$all_groups = array_reduce($all_groups, function ($acc, $curr) {
			$added = array_search($curr['id'], array_column($acc, 'id'));

			return $added === false ? array(...$acc, $curr) : $acc;
		}, array());


		return $all_groups;
	}
}
