<?php

namespace Rubicore\Ldap;

use Rubicore\Core\Db_Helper;

final class User_Repository
{

	public function get()
	{
		$users = Ldap_Helper::search("(&(cn=*)(pidcategory=Emp))");
		$all_users = array();

		foreach ($users as $user) {
			$uid = Ldap_Helper::get_value($user, 'uid', null);

			if (!$uid) {
				continue;
			}

			$groups = Ldap_Helper::get_value($user, 'cidorganizationstringmv', array());
			$groups_main = Ldap_Helper::get_value($user, 'cidorganizationstringmain', array());
			$groups = array_diff($groups, $groups_main);
			$jobs = Ldap_Helper::get_value($user, 'pidjobcode', array());

			$all_users[] = array(
				'uid' => $uid,
				'groups' => Group_Helper::parse_groups($groups),
				'groups_main' => Group_Helper::parse_groups($groups_main),
				'first_name' => Ldap_Helper::get_value($user, 'givenname', ''),
				'last_name' => Ldap_Helper::get_value($user, 'sn', ''),
				'email' => Ldap_Helper::get_value($user, 'mail', ''),
				'jobs' => is_array($jobs) ? $jobs : [$jobs],
				'mobile' => Ldap_Helper::get_value($user, 'akMobileNumber', ''),
				'phone' => Ldap_Helper::get_value($user, 'akPhoneNumber', '')
			);
		}

		unset($user);

		return $all_users;
	}


	public function get_main_nodes(int $user_id, string $type) : array
	{
		$user_node_table = Db_Helper::table('user_node');
		$category_table = Db_Helper::table('category');
		$category_node_table = Db_Helper::table('category_node');
		$node_table = Db_Helper::table('node');

		return Db_Helper::get_rows("
			SELECT * FROM {$category_table} AS c

			INNER JOIN {$category_node_table} AS cn
			ON cn.category_id = c.id

			INNER JOIN {$node_table} AS n
			ON n.id = cn.node_id

			INNER JOIN {$user_node_table} AS un
			ON un.node_id = n.id
			AND un.user_id = %d
			AND un.main = true

			WHERE c.type = %s
		", [$user_id, $type]);
	}
}
