<?php

final class RUBICORE_Ldap_Users {


	public static function update_user($user) {
		$user_row = get_user_by('login', $user['uid']);

		$userdata = array(
			'user_login' => $user['uid'],
			'user_nicename' => $user['uid'],
			'user_email' => $user['email'],
			'display_name' => $user['first_name'] . ' ' . $user['last_name'],
			'nickname' => $user['uid'],
			'first_name' => $user['first_name'],
			'last_name' => $user['last_name']
		);

		if (!empty($user_row)) {
			$userdata['ID'] = $user_row->ID;
		} else {
			$userdata['user_pass'] = wp_hash_password('test');
		}

		$user_id = wp_insert_user($userdata);

		return $user_id;
	}


	private static function update_category_nodes(int $user_id, array $groups, bool $is_main = false) {
		$node_table = RUBICORE_Db::table('node');
		$user_node_table = RUBICORE_Db::table('user_node');

		foreach ($groups as $group) {
			$node = RUBICORE_Db::get_row("SELECT * FROM $node_table WHERE value = %s", [$group['id']]);

			if (is_null($node)) {
				continue;
			}

			$row = RUBICORE_Db::get_row(
				"SELECT * FROM $user_node_table
				WHERE user_id = %d
				AND node_id = %d"
			, array($user_id, $node->id));

			if (is_null($row)) {
				RUBICORE_Db::insert('user_node', array(
					'user_id' => $user_id,
					'node_id' => $node->id,
					'main' => $is_main
				), array(
					'%d',
					'%d',
					'%d'
				));
			}
		}
	}

	private static function set_user_management($user_id, $main_groups) {
		if (array_key_exists(2, $main_groups)) {
			update_user_meta($user_id, 'management', $main_groups[2]['name']);
		}
	}

	private static function update_user_groups($user_id, $user_data) {
		self::set_user_management($user_id, $user_data['groups_main']);
		self::update_category_nodes($user_id, $user_data['groups_main'], true);
		self::update_category_nodes($user_id, $user_data['groups']);
		self::update_category_nodes($user_id, $user_data['jobs'], true);
	}

	public static function register_routes(): void {

		RUBICORE_Api::add_route('rubicore/v1', 'ldap/sync/users', ['POST'], function (WP_REST_Request $req) {
			$users = RUBICORE_Ldap::get_all_users();
			$ret = array();

			foreach ($users as $user) {
				$user_id = self::update_user($user);

				if (!is_numeric($user_id)) {
					$uid = $user['uid'];
					array_push($ret, "Something went wrong updating user $uid");

					continue;
				}

				self::update_user_groups($user_id, $user);
			}

			return $ret;
		});
	}

}
