<?php

final class RUBICORE_Ldap_Groups {

	public static function update_groups(array $groups): array {
		$response_log = array();

		$category_table = RUBICORE_Db::table('category');
		$node_table = RUBICORE_Db::table('node');

		$category_node = RUBICORE_Db::get_row("SELECT * FROM $category_table WHERE category_key = %s", ['cidorganizations']);

		if (!$category_node) {
			RUBICORE_Utils::die('No category with key "cidorganizations" found');
		}

		foreach ($groups as $group) {
			$external_id = $group['id'];
			$parent_external_id = is_null($group['parent']) ? "" : $group['parent'];
			$name = $group['name'];

			if (is_null($external_id)) {
				continue;
			}

			// Check if group exists
			$node = RUBICORE_Db::get_row("SELECT * FROM $node_table WHERE value = %s", [$external_id]);

			if (is_null($node)) {
				$row_id = RUBICORE_Db::insert('node', array(
					'value' => $external_id,
					'name' => $name
				), array(
					'%s',
					'%s'
				));

				$response_log[] = "Inserted new group $name";

				RUBICORE_Db::insert('category_node', array(
					'category_id' => $category_node->id,
					'node_id' => $row_id
				), ['%d', '%d']);

				continue;
			}

			// Update name if they differ
			if ($node->name != $name) {
				RUBICORE_Db::update($node_table, array(
					'name' => $name
				), array(
					'id' => $node->id
				));

				$response_log[] = "Update group name from $node->name to $name";
			}
		}

		return $response_log;
	}



	private static function update_parents(array $groups): void {
		$node_table = RUBICORE_Db::table('node');

		foreach ($groups as $group) {
			$external_id = $group['id'];
			$parent_external_id = is_null($group['parent']) ? "" : $group['parent'];

			if (is_null($external_id)) {
				continue;
			}

			// Check if group exists
			$row = RUBICORE_Db::get_row("SELECT * FROM $node_table WHERE value = %s", array($external_id));

			// Set parent if missing
			if (!is_null($row) && $row->parent == null && $parent_external_id != '') {
				$parent_row = RUBICORE_Db::get_row("SELECT * FROM $node_table WHERE value = %s", [$parent_external_id]);

				RUBICORE_Db::update('node', array(
					'parent' => $parent_row->id
				), array(
					'id' => $row->id
				), ['%d']);
			}
		}
	}



	public static function register_routes(): void {

		RUBICORE_Api::add_route('rubicore/v1', 'ldap/sync/groups', ['POST'], function (WP_REST_Request $req) {
			//$all_groups = RUBICORE_Ldap::get_all_groups();
			$all_groups = json_decode(json_encode(RUBICORE_Utils::body($req)), true);;
			$response_log = self::update_groups($all_groups);

			self::update_parents($all_groups);

			return $response_log;
		});

	}

}
