<?php

namespace Rubicore\Ldap;

final class Group_Repository
{
	private string $node_table;

	function __construct()
	{
		$this->category_table = \Rubicore\Core\Db_Helper::table('category');
		$this->node_table = \Rubicore\Core\Db_Helper::table('node');
	}

	public function get() : array
	{
		$users = Ldap_Helper::search("(&(cn=*)(pidcategory=Emp))");
		$all_groups = array();

		foreach ($users as $user) {
			$groups = Ldap_Helper::get_value($user, 'cidorganizationstringmv', array());
			$groups_arr = Group_Helper::parse_groups($groups);
			array_push($all_groups, ...$groups_arr);
		}

		unset($user);

		$all_groups = array_reduce($all_groups, function ($acc, $curr) {
			$added = array_search($curr['id'], array_column($acc, 'id'));

			return $added === false ? array(...$acc, $curr) : $acc;
		}, array());

		return $all_groups;
	}


	public function create(array $groups, ?int $category_id) : void
	{

		foreach ($groups as $group) {
			$external_id = $group->id;
			//$parent_external_id = is_null($group->parent) ? "" : $group->parent;
			$name = $group->name;

			if (is_null($external_id)) {
				continue;
			}

			// Check if group exists
			$node = \Rubicore\Core\Db_Helper::get_row("SELECT * FROM $this->node_table WHERE value = %s", [$external_id]);

			if (is_null($node)) {
				$node_id = \Rubicore\Core\Db_Helper::insert('node', array(
					'value' => $external_id,
					'name' => $name
				), array(
					'%s',
					'%s'
				));


				if ($category_id) {
					\Rubicore\Core\Db_Helper::insert('category_node', array(
						'category_id' => $category_id,
						'node_id' => $node_id
					), ['%d', '%d']);
				}

				continue;
			}

			// Update name if they differ
			if ($node->name != $name) {
				\Rubicore\Core\Db_Helper::update('node', array(
					'name' => $name
				), array(
					'id' => $node->id
				));
			}
		}
	}

	public function update_parents(array $groups): void
	{
		foreach ($groups as $group) {
			$external_id = $group->id;
			$parent_external_id = is_null($group->parent) ? "" : $group->parent;

			if (is_null($external_id)) {
				continue;
			}

			// Check if group exists
			$row = \Rubicore\Core\Db_Helper::get_row("SELECT * FROM $this->node_table WHERE value = %s", [$external_id]);

			// Set parent if missing
			if (!is_null($row) && $row->parent == null && $parent_external_id != '') {
				$parent_row = \Rubicore\Core\Db_Helper::get_row("SELECT * FROM $this->node_table WHERE value = %s", [$parent_external_id]);

				\Rubicore\Core\Db_Helper::update('node', array(
					'parent' => $parent_row->id
				), array(
					'id' => $row->id
				), ['%d']);
			}
		}
	}

}
