<?php

namespace Rubicore\Ldap;

use \WP_REST_Request, \WP_User;

final class Group_Controller {

	function __construct() {
		$this->routes();
	}

	private function routes(): void
	{
		$api = new \Rubicore\Core\Api_Helper('rubicore/ldap/v1');

		$api->add_route('group', 'GET', function (WP_REST_Request $req, WP_User $user): array {
			$group_repo = new Group_Repository();
			$groups = $group_repo->get();

			return array_map(fn($val) : Group_Model => Group_Transformer::transform_out($val), $groups);
		});


		$api->add_route('group', 'POST', function (WP_REST_Request $req, WP_User $user): void {
			$group_repo = new Group_Repository();
			$body = \Rubicore\Core\Request_Helper::get_body($req);

			if (!is_array($body)) {
				\Rubicore\Core\Response_Helper::die('Body must be type of array.');
			}

			$category_id = $req->get_param('categoryId') ? intval($req->get_param('categoryId')) : null;

			if ($category_id) {
				$category = (new \Rubicore\Core\Category_Repository())->get_by_id($category_id);

				if (!$category) {
					\Rubicore\Core\Response_Helper::not_found('No category found with provided id.');
				}
			}

			$group_repo->create($body, $category_id);
			$group_repo->update_parents($body);
		}, array(
			'args' => array(
				'categoryId' => array(
					'type' => 'int',
					'required' => false,
					'minumum' => 1
				)
			)
		));

	}
}
