<?php

namespace Rubicore\Core;

final class User_Link_Repository {

	public function get(int $user_id, int $link_id) : ?object {
		$user_link_table = Db_Helper::table("user_link");

		return Db_Helper::get_row("
			SELECT * FROM ${user_link_table} AS ul
			WHERE ul.user_id = %d
			AND ul.link_id = %d"
		, [$user_id, $link_id]);
	}

	public function add(int $user_id, int $link_id) : void {
		$row = $this->get($user_id, $link_id);

		if ($row) {
			Db_Helper::update('user_link', [
				'disabled' => false
			], [
				'user_id' => $user_id,
				'link_id' => $link_id
			], ['%d', '%d']);

			return;
		}

		Db_Helper::insert('user_link', array(
			'user_id' => $user_id,
			'link_id' => $link_id,
			'sort' => -1
		), ['%d', '%d', '%d']);
	}

	public function remove(int $user_id, int $link_id) : void {
		Db_Helper::update('user_link', ['disabled' => true], [
			'user_id' => $user_id,
			'link_id' => $link_id
		], ['%d', '%d']);
	}

}
