<?php

namespace Rubicore\Core;

final class User_Helper {

	public static function allowed_to(string $cap, \WP_User $user, $user_ids = null): void {
		if (is_array($user_ids)) {
			foreach($user_ids as $user_id) {
				if ($user->ID == $user_id) {
					return;
				}
			}
		}

		if (is_numeric($user_ids) && $user->ID == $user_ids) {
			return;
		}

		if (!$user->has_cap($cap)) {
			Response_Helper::not_authorized("Permission denied, missing capability '$cap'.");
		}
	}

	public static function is_authorized(\WP_REST_Request $req) : array {
		$token = Token_Helper::get_from_request($req);
		$token_status = Token_Helper::validate($token);

		if (!$token_status['is_valid']) {
			return $token_status;
		}

		$user_id = Token_Helper::get_user_id($token);
		$token_repo = new Token_Repository();

		$db_token = $token_repo->get_by_token($token, $user_id);

		if (!$db_token) {
			return array(
				'is_valid' => false,
				'msg' => 'Invalid token'
			);
		}

		return array(
			'is_valid' => true,
			'msg' => 'Valid token'
		);
	}

	public static function filter_meta(array $meta) : array {
		$meta_blacklist = [
			'rich_editing', 'nickname', 'syntax_highlighting', 'comment_shortcuts', 'admin_color',
			'use_ssl', 'show_admin_bar_front', 'locale', 'kp_wp_capabilities', 'kp_wp_user_level',
			'dismissed_wp_pointers', 'session_tokens', 'kp_wp_dashboard_quick_press_last_post_id',
			'community-events-location', 'first_name', 'last_name', 'show_welcome_panel'];

		$ret = array();

		foreach ($meta as $key => $value) {
			if (!in_array($key, $meta_blacklist)) {
				if(isset($value[0])) {
					$ret[$key] = $value[0];
				}
			}
		}

		return $ret;
	}

	public static function filter_capabilities(array $user_caps, array $rubicore_caps) : object {
		$ret = new \stdClass();

		foreach ($user_caps as $key => $value) {
			$index = array_search($key, array_column($rubicore_caps, 'key'));

			if ($index !== false) {
				$ret->{$key} = $value;
			}
		}

		return $ret;
	}

}
