<?php

namespace Rubicore\Core;

final class Course_Transformer
{
	public static function transform_attendee_out(object $data): Course_Attendee_Model
	{
		$model = new Course_Attendee_Model();

		$model->id = $data->id;
		$model->status = $data->status ?? '';
		$model->information = $data->information ?? '';
		$model->created = $data->created ?? '';
		$model->user = $data->user ? User_Transformer::transform_list_out($data->user) : null;

		return $model;
	}

	public static function transform_out(object $data, ?array $attendees): ?Course_Model
	{
		$model = new Course_Model();

		$model->startDate = $data->meta['course_startDate'] ?? null;
		$model->endDate = $data->meta['course_endDate'] ?? null;
		$model->cancellationDate = $data->meta['course_cancellationDate'] ?? null;
		$model->place = $data->meta['course_place'] ?? null;
		$model->numberOfAttendees = $data->meta['course_numberOfAttendees'] ?? null;
		$model->bookable = $data->meta['course_bookable'] ?? null;
		$model->attendeeInformation = $data->meta['course_attendeeInformation'] ?? null;
		$model->attendees = $attendees;

		return $model;
	}
}
