<?php

namespace Rubicore\Core;

final class Course_Repository
{

	public function get_by_post_id(int $post_id, ?int $user_id) : ?array
	{
		$course_user_table = Db_Helper::table('course_user');

		if ($user_id) {
			return Db_Helper::get_rows("SELECT * FROM {$course_user_table} WHERE post_id = %d AND user_id = %d ORDER BY created ASC", [$post_id, $user_id]);
		}

		return Db_Helper::get_rows("SELECT * FROM {$course_user_table} WHERE post_id = %d ORDER BY created ASC", [$post_id]);
	}

	public function update_attendee(int $post_id, int $user_id, object $body) : void
	{
		Db_Helper::update('course_user',
			[
				'information' => $body->information
			],
			[
				'post_id' => $post_id,
				'user_id' => $user_id
			], [
				'%s'
			], [
				'%d',
				'%d'
			]
		);
	}

	public function add_attendee(int $post_id, int $user_id, object $body) : void
	{
		Db_Helper::insert(
			'course_user',
			[
				'post_id' => $post_id,
				'user_id' => $user_id,
				'information' => $body->information
			],
			['%d','%d', '%s']
		);
	}

	public function remove_attendee(int $post_id, int $user_id) : void
	{
		Db_Helper::delete(
			'course_user',
			[
				'post_id' => $post_id,
				'user_id' => $user_id
			],
			[
				'%d',
				'%d'
			]
		);
	}

	public function get_by_attendee_id(array $params, int $user_id) : array
	{
		$course_user_table = Db_Helper::table('course_user');
		$post_table = Db_Helper::table('posts');

		$post_repo = new Post_Repository();
		$q = new Query_Builder_Helper($params, Post_Query::$fields);

		$where = "WHERE p.post_type = 'course'";

		$where = Query_Helper::add_where($q->filter_query, $where, "AND", $q->filter_query);
		$where = Query_Helper::add_where($q->search_query, $where, "AND", $q->search_query);

		$join = Db_Helper::prepare("
			INNER JOIN {$course_user_table} AS cu
			ON cu.user_id = %d
			AND cu.post_id = p.id
			", [$user_id]);

		$count_query = "SELECT COUNT(DISTINCT p.ID) AS num_rows FROM $post_table AS p $join $where";
		$total_count = Db_Helper::get_row($count_query)->num_rows;
		Response_Helper::set_pagination_total_header($total_count);

		$posts = Db_Helper::get_rows("SELECT DISTINCT p.* FROM $post_table AS p $join $where $q->order_by_query $q->limit_query");

		foreach ($posts as $post) {
			$meta = get_post_meta($post->ID);
			$post->meta = [];

			foreach ($meta as $key => $value) {
				$post->meta[$key] = $value[0];
			}

			$post->media_id = isset($post->meta['mediaId']) ? intval($post->meta['mediaId']) : null;
			$post->node_ids = $post_repo->get_node_ids($post->ID);
			$post->category_ids = $post_repo->get_category_ids($post->ID);
			$post->user_ids = $post_repo->get_user_ids($post->ID);
			$post->editor_ids = $post_repo->get_editor_ids($post->ID);
		}

		return $posts;
	}
}
