<?php

namespace Rubicore\Core;
use \WP_REST_Request, \WP_User;

final class User_Controller {

	function __construct () {
		$this->routes();
	}


	private function routes() : void {
		$api = new Api_Helper('rubicore/core/v1');


		$api->add_route('user', 'GET', function (WP_REST_Request $req, WP_User $user) : array {
			User_Helper::allowed_to('user_list', $user, $req->get_param('id'));

			$params = $req->get_params();


			return User_Service::get($params);
		}, array(
			'args' => array_merge(
				User_Query::get_args(),
				Query_Helper::get_pagination_args()
			)
		));



		$api->add_route('user/(?P<user_id>[^/]+?)', 'GET', function (WP_REST_Request $req, WP_User $user) : User_Model {
			$user_id = $req->get_param('user_id');

			return User_Service::get_by_identifier($user_id);
		}, [
			'args' => [
				'user_id' => ['type' => [Api_Helper::TYPE_INT, Api_Helper::TYPE_STRING]]
			]
		]);



		$api->add_route('user/(?P<user_id>\d+)', 'PUT', function (WP_REST_Request $req, WP_User $user) : void {
			User_Helper::allowed_to('user_edit', $user, $req->get_param('user_id'));

			$repo = new User_Repository();
			$body = Request_Helper::get_body($req);

			if ($body->meta) {
				$repo->update_meta($req->get_param('user_id'), User_Transformer::meta_transform_in($body->meta));
			}
		}, array(
			'args' => array(
				'user_id' => array('type' => Api_Helper::TYPE_INT, 'required' => true, 'minimum' => 1)
			)
		));

	}
}
