<?php if (!defined('ABSPATH')) {
	exit;
}

/*
Plugin Name: Rubicore Core
Plugin URI:
Description: Core plugin for Rubicore framework
Version: 2.6.0
Author: Knowe AB
Author URI: https://knowe.se
Text Domain: Rubicore
*/

define('RUBICORE_ROOT_DIR', WP_PLUGIN_DIR . '/rubicore-core');
define('WP_POST_REVISIONS', false);
// TODO: Disable rest-routes annat än rubicore
// TODO: Lägg till "in" property på alla args-scheman

ini_set('html_errors', false);
global $wpdb;
$wpdb->suppress_errors = true;

include_once RUBICORE_ROOT_DIR . '/autoloader.php';
include_once RUBICORE_ROOT_DIR . '/main.php';
include_once RUBICORE_ROOT_DIR . '/filters.php';

Rubicore\Core\Autoloader::register_autoloader(RUBICORE_ROOT_DIR, 'Rubicore\\Core\\');

new Rubicore\Core\Main();
Rubicore\Core\Update_Helper::register_plugin('rubicore-core');

add_action('init', function () {
	Rubicore\Core\Posttype_Installer::create_default_post_types();
	do_action('rubicore_init');
});

add_action('admin_menu', function () {
	Rubicore\Core\Ui_Helper::setup_menu();

	do_action('rubicore_admin_menu');
});

add_action('admin_init', function () {
	if (!wp_doing_ajax()) {
		do_action('rubicore_admin_init');
	}
});

add_action('admin_enqueue_scripts', function () {
	wp_enqueue_script('rubicore-script', plugin_dir_url(__FILE__) . '/scripts/admin.js', array(), '1.0.0', true);
});

register_activation_hook(__FILE__, function () {
	$db_installer = new Rubicore\Core\Database_Installer();
	$db_installer->create_tables();

	$role_installer = new Rubicore\Core\Role_Installer();
	$role_installer->create_default_roles();
});



