<?php

namespace Rubicore\Core;

final class Post_User_Repository
{
	private string $post_user_table;

	function __construct()
	{
		$this->post_user_table = Db_Helper::table('post_user');
	}

	public function get_by_post_id(int $post_id) : array
	{
		return Db_Helper::get_rows("SELECT * FROM {$this->post_user_table} AS p WHERE p.post_id = %d", [$post_id]);
	}

	public function add(int $post_id, int $user_id): void
	{
		Db_Helper::insert('post_user', array(
			'post_id' => $post_id,
			'user_id' => $user_id
		), ['%d', '%d', '%d']);
	}

	public function remove(int $post_id, int $user_id): void
	{
		Db_Helper::delete('post_user', array(
			'post_id' => $post_id,
			'user_id' => $user_id
		), ['%d', '%d']);
	}

	public function remove_all(int $post_id): void
	{
		Db_Helper::delete('post_user', array(
			'post_id' => $post_id
		), ['%d']);
	}
}
