<?php

namespace Rubicore\Core;

final class Ui_Helper
{

	public static function setup_menu(): void
	{
		add_menu_page(
			'Rubicore Options',
			'Rubicore',
			'manage_options',
			'rubicore',
			function ($args) {
				self::create_default_page($args);
			},
			'dashicons-superhero',
			2
		);
	}

	public static function add_page(array $opts): void
	{
		add_submenu_page(
			'rubicore',
			$opts['name'],
			$opts['name'],
			'manage_options',
			$opts['slug'],
			function ($args) use ($opts) {

				if (isset($_POST['submit'])) {
					self::save_options($_POST, $opts);
				}

?>
			<h1><?php echo $opts['title']; ?></h1>
			<form method="POST">
				<?php self::create_form($opts['settings_key'], $opts['settings']); ?>
			</form>
		<?php
			},
			10
		);
	}

	private static function save_options(array $post_data, array $opts): void
	{
		$data = array();

		foreach ($opts['settings'] as $item) {
			$value = isset($post_data[$item['key']]) ? $post_data[$item['key']] : (isset($item['default']) ? $item['default'] : null);

			$data[$item['key']] = $value;
		}


		add_option($opts['settings_key'], $data);
		update_option($opts['settings_key'], $data);
	}

	private static function create_form(string $settings_key, array $settings)
	{
		$options = get_option($settings_key);

		foreach ($settings as $item) : ?>

			<div style="margin-bottom: 10px;">
				<label for="<?php echo $item['key']; ?>"><?php echo $item['label'] ?></label>
				<br />
				<input id="<?php echo $item['key']; ?>" type="<?php echo $item['type']; ?>" name="<?php echo $item['key']; ?>" value="<?php echo isset($options[$item['key']]) ? $options[$item['key']] : ''; ?>" <?php
																																																				if ($item['type'] == 'checkbox' && (isset($options[$item['key']]) ? $options[$item['key']] : false) == true) {
																																																					echo 'checked="true"';
																																																				}
																																																				?> />
				<br />
				<?php if (isset($item['desc'])) : ?>
					<p style="margin-top: 0px;">
						<?php echo $item['desc']; ?>
					</p>
				<?php endif; ?>
			</div>

		<?php endforeach;

		submit_button();
	}


	private static function create_default_page($args)
	{
		if (isset($_POST['submit']) && isset($_POST['user_id'])) {
			$user_capability_repo = new User_Capability_Repository();
			$caps_data = (new Capability_Data())->get();
			$user_id = intval($_POST['user_id']);

			foreach ($caps_data as $cap) {
				$key = $cap['key'];

				$user_capability_repo->add($user_id, $key, true);

				echo "Användare beviljad rättighet {$key} ({$cap['desc']}) <br/>";
			}
		}

		?>
		<form method="POST">
			<div style="margin-bottom: 10px;">
				<label for="user_id">AnvändarID</label>
				<br />
				<input id="user_id" type="text" name="user_id" value="" />
				<br />
				<p style="margin-top: 0px;">
					Gör användare till super-admin för Rubicore
				</p>
			</div>

			<?php submit_button(); ?>
		</form>
		<?php
	}
}
