<?php

namespace Rubicore\Core;

use \WP_REST_Request, \WP_User;

final class User_Node_Controller
{

	function __construct()
	{
		$this->routes();
	}


	private function routes(): void
	{
		$api = new Api_Helper('rubicore/core/v1');

		// get all NODES for user
		$api->add_route('user/(?P<user_id>\d+)/node', 'GET', function (WP_REST_Request $req, WP_User $user): array {
			$user_id = $req->get_param('user_id');
			$main = $req->get_param('main');

			//User_Helper::allowed_to('user_node_get', $user, $user_id);
			// TODO: fix this ^ ?

			$node_repo = new Node_Repository();
			$user_repo = new User_Repository();

			if (!$user_repo->get_by_id($user_id)) {
				Response_Helper::not_found("No user found with provided id.");
			}

			$nodes = $node_repo->get_by_user_id($user_id, $main);

			return array_map(fn($node) : Node_Model => Node_Transformer::transform_out($node), $nodes);
		}, [
			'args' => [
				'main' => ['type' => [Api_Helper::TYPE_BOOL, Api_Helper::TYPE_NULL], 'required' => false],
				'user_id' => ['type' => Api_Helper::TYPE_INT, 'required' => true, 'minimum' => 1]
			]
		]);

		// add NODE
		$api->add_route('user/(?P<user_id>\d+)/node/(?P<node_id>\d+)', 'POST', function (WP_REST_Request $req, WP_User $user): void {
			User_Helper::allowed_to('user_node_add', $user, $req->get_param('user_id'));

			$node_repo = new Node_Repository();
			$user_repo = new User_Repository();
			$user_node_repo = new User_Node_Repository();

			$user_id = $req->get_param('user_id');
			$node_id = $req->get_param('node_id');
			$main = $req->get_param('main');

			if (!$user_repo->get_by_id($user_id)) {
				Response_Helper::not_found("No user found with provided id.");
			}

			if (!$node_repo->get_by_id($node_id)) {
				Response_Helper::not_found("No node found with provided id.");
			}

			$user_node_repo->add($user_id, $node_id, $main);
		}, [
			'args' => [
				'main' => ['type' => Api_Helper::TYPE_BOOL, 'required' => false, 'default' => false],
				'user_id' => ['type' => Api_Helper::TYPE_INT, 'required' => true, 'minimum' => 1],
				'node_id' => ['type' => Api_Helper::TYPE_INT, 'required' => true, 'minimum' => 1]
			]
		]);



		// remove NODE
		$api->add_route('user/(?P<user_id>\d+)/node/(?P<node_id>\d+)', 'DELETE', function (WP_REST_Request $req, WP_User $user): void {
			User_Helper::allowed_to('user_node_remove', $user, $req->get_param('user_id'));

			$user_node_repo = new User_Node_Repository();

			$user_id = $req->get_param('user_id');
			$node_id = $req->get_param('node_id');

			$row = $user_node_repo->get_by_id($user_id, $node_id);

			if (!$row) {
				Response_Helper::not_found("No entry found with provided ids.");
			}

			if ($row[0]->main) {
				Response_Helper::bad("Unable to delete main node.");
			}

			$user_node_repo->remove($user_id, $node_id);
		}, [
			'args' => [
				'user_id' => ['type' => Api_Helper::TYPE_INT, 'required' => true, 'minimum' => 1],
				'node_id' => ['type' => Api_Helper::TYPE_INT, 'required' => true, 'minimum' => 1]
			]
		]);
	}
}
