<?php

namespace Rubicore\Core;

final class Post_Transformer {

	public static function transform_out(object $data) : Post_Model
	{
		$model = new Post_Model();

		$model->id = $data->ID;
		$model->title = $data->post_title;
		$model->content = $data->post_content ?? null;
		$model->excerpt = $data->post_excerpt;
		$model->publishedDate = $data->post_date;
		$model->updatedDate = $data->post_modified;
		$model->status = $data->post_status;
		$model->slug = $data->post_name;
		$model->allowComments = $data->comment_status == 'open';
		$model->commentCount = $data->comment_count;
		$model->type = $data->post_type;
		$model->order = $data->menu_order;
		$model->parentId = $data->post_parent == 0 ? null : $data->post_parent;
		$model->author = $data->user ? User_Transformer::transform_list_out($data->user) : null;
		$model->media = $data->media ? Media_Transformer::transform_out($data->media) : null;
		$model->course = $data->post_type == 'course' ? Course_Transformer::transform_out($data, $data->course_attendees) : null;

		$model->blurbs = $data->meta['blurbs'] ?? null;
		$model->info = $data->meta['info'] ?? null;
		$model->contact = $data->meta['contact'] ?? null;
		$model->unpublishedDate = $data->meta['unpublishedDate'] ?? null;
		$model->authoredDate = $data->meta['authoredDate'] ?? null;
		$model->pseudoAuthor = $data->meta['pseudoAuthor'] ?? null;

		$model->categoryIds = $data->category_ids ?: [];
		$model->nodeIds = $data->node_ids ?: [];
		$model->userIds = $data->user_ids ?: [];
		$model->editorIds = $data->editor_ids ?: [];

		return $model;
	}

	public static function transform_in(object $data) : Post_Entity {
		$entity = new Post_Entity();

		$entity->post_author = $data->authorId;
		$entity->post_date = $data->publishedDate ?? null;
		$entity->post_title = $data->title;
		$entity->post_content = $data->content;
		$entity->post_excerpt = $data->excerpt;
		$entity->post_type = $data->type;
		$entity->post_status = $data->status ?? 'publish';
		$entity->comment_status = $data->allowComments ? 'open' : 'closed';
		$entity->post_name = $data->slug ?? null;
		$entity->post_parent = $data->parentId ?? 0;
		$entity->menu_order = $data->order ?? 0;

		return $entity;
	}
}
