<?php

namespace Rubicore\Core;

use \WP_REST_Request, \WP_User;

final class User_Service
{
	public static function get(array $params) : array
	{
		$user_repo = new User_Repository();
		$user_category_repo = new User_Category_Repository();

		$users = $user_repo->get($params);

		return array_map(function ($user) use($user_category_repo) : User_Model {
			$categories = $user_category_repo->get_user_categories($user->ID);

			$user->categories = array_map(fn ($category) => Category_Transformer::transform_out($category), $categories);

			return  User_Transformer::transform_out($user);
		}, $users);
	}

	public static function get_by_identifier($identifier, array $categoryTypes) : ?User_Model
	{
		//User_Helper::allowed_to('user_get', $user, $user_id);

		$user_repo = new User_Repository();
		$user = $user_repo->get_by_id($identifier);

		if (!$user) {
			Response_Helper::not_found('No user found with provided id.');
		}

		$user_category_repo = new User_Category_Repository();
		$categories = $user_category_repo->get_user_categories($user->ID);

		$user->categories = array_map(fn($category) => Category_Transformer::transform_out($category), $categories);

		return User_Transformer::transform_out($user);
	}
}
