<?php

namespace Rubicore\Core;

final class User_Repository {
	private string $user_node_table;
	private string $user_table;

	function __construct () {
		$this->user_node_table = Db_Helper::table('user_node');
		$this->user_table = Db_Helper::table('users');
	}

	public function get(array $params) : array
	{
		$q = new Query_Builder_Helper($params, User_Query::$fields);
		$where = "";

		$where = Query_Helper::add_where(boolval($q->search_query), $where, "AND", $q->search_query);
		$where = Query_Helper::add_where(boolval($q->filter_query), $where, "AND", $q->filter_query);

		$count_query = Query_Helper::get_count("FROM $this->user_table $where");
		$total_count = Db_Helper::get_row($count_query)->num_rows;

		Response_Helper::set_pagination_total_header($total_count);


		$main_query = "SELECT * FROM $this->user_table $where $q->order_by_query $q->limit_query";

		$rows = Db_Helper::get_rows($main_query);

		foreach ($rows as $row) {
			$row->meta = $this->get_meta($row->ID);
		}

		return $rows;
	}

	public function get_by_id($input) : ?object
	{
		$user = is_numeric($input) ?
			Db_Helper::get_row("SELECT * FROM $this->user_table WHERE id = %d", [$input]) :
			Db_Helper::get_row("SELECT * FROM $this->user_table WHERE user_login = %s", [$input]);


		if ($user) {
			$user->meta = $this->get_meta($user->ID);
		}

		return $user;
	}

	public function get_meta(int $id) : array
	{
		return get_user_meta($id);
	}

	public function update_meta(int $user_id, User_Meta_Entity $meta) : void
	{
		foreach ($meta->to_array() as $key => $value) {
			if (!is_null($value)) {
				update_user_meta($user_id, $key, $value);
			}
		}
	}

	public function get_users_by_node(int $node_id) : array
	{
		$rows = Db_Helper::get_rows(
			"SELECT uci.user_id FROM $this->user_node_table AS uci
			WHERE uci.node_id = %d
			AND uci.main = true", [$node_id]
		);

		$ret = [];

		foreach($rows as $row) {
			$ret[] = intval($row->user_id);
		}

		return $ret;
	}
}
