<?php

namespace Rubicore\Core;

final class User_Category_Repository {

	public function add(int $user_id, int $category_id) : void {
		Db_Helper::insert('user_category', array(
			'user_id' => $user_id,
			'category_id' => $category_id
		), ['%d', '%d']);
	}

	public function remove(int $user_id, int $category_id) : void {
		Db_Helper::delete('user_category', array(
			'user_id' => $user_id,
			'category_id' => $category_id
		), ['%d', '%d']);
	}

	public function get_user_categories(int $user_id) : array
	{
		$user_node_table = Db_Helper::table('user_node');
		$node_table = Db_Helper::table('node');
		$category_node_table = Db_Helper::table('category_node');
		$category_table = Db_Helper::table('category');

		$rows = Db_Helper::get_rows("
			SELECT
				n.id AS node_id,
				n.name AS node_name,
				n.value AS node_value,
				n.parent AS node_parent,
				un.main AS node_is_main,
				c.id AS category_id,
				c.name AS category_name,
				c.type AS category_type,
				c.category_key
			FROM {$user_node_table} AS un

			INNER JOIN {$node_table} AS n
			ON n.id = un.node_id

			INNER JOIN {$category_node_table} AS cn
			ON cn.node_id = n.id

			INNER JOIN {$category_table} AS c
			ON c.id = cn.category_id

			WHERE un.user_id = %d
		", [$user_id]);

		$data = [];
		$ret = [];

		foreach ($rows as $row) {
			if (!array_key_exists($row->category_type, $data)) {
				$cat = new \stdClass();
				$cat->nodes = [];
				$cat->id = $row->category_id;
				$cat->name = $row->category_name;
				$cat->type = $row->category_type;
				$cat->category_key = $row->category_key;

				$data[$row->category_type] = $cat;
			}

			$node = new \stdClass();

			$node->id = $row->node_id;
			$node->value = $row->node_value;
			$node->main = $row->node_is_main;
			$node->name = $row->node_name;
			$node->parent = $row->node_parent;

			$data[$row->category_type]->nodes[] = $node;
		}

		foreach ($data as $value) {
			$ret[] = $value;
		}

		return $ret;
	}
}
