<?php

namespace Rubicore\Core;

final class Token_Repository {

	private string $token_table;

	function __construct () {
		$this->token_table = Db_Helper::table('token');
	}

	public function get(array $params, ?bool $expired) : array {
		$q = new Query_Builder_Helper($params, Token_Query::$fields);
		$where = "";

		if (!is_null($expired)) {
			$now = time();

			$where = Query_Helper::add_where($expired, $where, "AND", Db_Helper::prepare("
				t.expires < %d
			", [$now]));

			$where = Query_Helper::add_where(!$expired, $where, "AND", Db_Helper::prepare("
				t.expires > %d
			", [$now]));
		}

		$where = Query_Helper::add_where($q->filter_query, $where, "AND", $q->filter_query);
		$where = Query_Helper::add_where($q->search_query, $where, "AND", $q->search_query);

		$count_query = Query_Helper::get_count("FROM $this->token_table AS t $where");
		$total_count = Db_Helper::get_row($count_query)->num_rows;

		Response_Helper::set_pagination_total_header($total_count);

		$main_query = "SELECT * FROM $this->token_table AS t $where $q->order_by_query $q->limit_query";

		$rows = Db_Helper::get_rows($main_query);

		return $rows;
	}

	public function get_by_id(int $token_id): ?object {
		return Db_Helper::get_row("SELECT * FROM $this->token_table WHERE id = %d", [$token_id]);
	}

	public function get_by_ref(string $ref): ?object {
		return Db_Helper::get_row("SELECT * FROM $this->token_table WHERE ref = %s", [$ref]);
	}

	public function get_by_token(string $token, ?int $user_id) : ?object {
		$row = $user_id ?
			Db_Helper::get_row("SELECT * FROM $this->token_table WHERE token = %s AND user_id = %d", [$token, $user_id]) :
			Db_Helper::get_row("SELECT * FROM $this->token_table WHERE token = %s", [$token]);

		return $row;
	}

	public function create(int $user_id, string $type, string $ref = '') : ?object {
		$payload = new \stdClass();
		$payload->type = $type;
		$payload->userId = $user_id;
		$payload->siteId = get_current_blog_id();

		$token_data = Token_Helper::create($payload);
		$token_id = Db_Helper::insert('token', array(
			'user_id' => $user_id,
			'token' => $token_data['token'],
			'expires' => $token_data['expires'],
			'type' => $type,
			'ref' => $ref
		), ['%d', '%s', '%d', '%s', '%s']);

		return $this->get_by_id($token_id);
	}

	public function delete(int $id): void {
		Db_Helper::delete('token', array('id' => $id), ['%d']);
	}

}
