<?php

namespace Rubicore\Core;

final class Role_Repository {

	function __construct () {

	}

	public function get_by_key(string $key) : ?object {
		$roles = $this->get();

		$ret = null;

		foreach($roles as $role) {
			if ($role->key == $key) {
				$ret = $role;
				break;
			}
		}

		return $ret;
	}

	public function get(?int $user_id = null) : array {
		$all_roles = wp_roles()->roles;
		$ret = [];
		$ignore = ['administrator', 'editor', 'author', 'contributor', 'subscriber'];

		if ($user_id) {
			$user_roles = get_userdata($user_id)->roles;

			foreach ($all_roles as $key => $role) {
				if (in_array($key, $ignore)) {
					continue;
				}

				if (in_array($key, $user_roles)) {
					$obj = new \stdClass();
					$obj->key = $key;
					$obj->name = $role['name'];

					$ret[] = $obj;
				}
			}

			return $ret;
		}

		foreach ($all_roles as $key => $role) {
			if (in_array($key, $ignore)) {
				continue;
			}

			$obj = new \stdClass();
			$obj->key = $key;
			$obj->name = $role['name'];

			$ret[] = $obj;
		}

		return $ret;
	}


	public function create(string $key, string $name, array $capabilities = []) : void {
		$key = sanitize_title($key);

		if ($this->get_by_key($key)) {
			Response_Helper::die("Role with provided name already exsists.");
		}

		add_role($key, $name, $capabilities);
	}


	public function delete(string $key) : void {
		if (in_array($key, [
			'rubicore-administrator', 'rubicore-user', 'rubicore-guest',
			'administrator', 'editor', 'author', 'contributor', 'subscriber'
		])) {
			Response_Helper::die("Unable to delete default roles.");
		}

		remove_role($key);
	}

}
