<?php

namespace Rubicore\Core;

final class Post_Category_Repository
{
	private string $post_category_table;

	function __construct()
	{
		$this->post_category_table = Db_Helper::table('post_category');
	}

	public function get_by_post_id(int $post_id): array
	{
		return Db_Helper::get_rows("SELECT * FROM {$this->post_category_table} AS p WHERE p.post_id = %d", [$post_id]);
	}

	public function add(int $post_id, int $category_id): void
	{
		Db_Helper::insert('post_category', array(
			'post_id' => $post_id,
			'category_id' => $category_id
		), ['%d', '%d', '%d']);
	}

	public function remove(int $post_id, int $category_id): void
	{
		Db_Helper::delete('post_category', array(
			'post_id' => $post_id,
			'category_id' => $category_id
		), ['%d', '%d']);
	}

	public function remove_all(int $post_id): void
	{
		Db_Helper::delete('post_category', array(
			'post_id' => $post_id
		), ['%d']);
	}
}
