<?php

namespace Rubicore\Core;

final class Course_Repository
{

	public function get_by_post_id(int $post_id, ?int $user_id) : ?array
	{
		$course_user_table = Db_Helper::table('course_user');

		if ($user_id) {
			return Db_Helper::get_rows("SELECT * FROM {$course_user_table} WHERE post_id = %d AND user_id = %d ORDER BY created ASC", [$post_id, $user_id]);
		}

		return Db_Helper::get_rows("SELECT * FROM {$course_user_table} WHERE post_id = %d ORDER BY created ASC", [$post_id]);
	}

	// TODO: Lägg till delete metod alt. lägg till så course_user tas bort i post repo

	public function update_attendee(int $post_id, int $user_id, object $body) : void
	{
		Db_Helper::update('course_user',
			[
				'status' => $body->status,
				'information' => $body->information
			],
			[
				'post_id' => $post_id,
				'user_id' => $user_id
			], [
				'%s',
				'%s'
			], [
				'%d',
				'%d'
			]
		);
	}

	public function add_attendee(int $post_id, int $user_id, object $body) : void
	{
		Db_Helper::insert(
			'course_user',
			[
				'post_id' => $post_id,
				'user_id' => $user_id,
				'status' => $body->status,
				'information' => $body->information
			],
			['%d','%d', '%s', '%s']
		);
	}

	public function remove_attendee(int $post_id, int $user_id) : void
	{
		Db_Helper::delete(
			'course_user',
			[
				'post_id' => $post_id,
				'user_id' => $user_id
			],
			[
				'%d',
				'%d'
			]
		);
	}
}
