<?php

namespace Rubicore\Core;

final class Api_Helper {

	public const TYPE_ARRAY = 'array';
	public const TYPE_BOOL = 'boolean';
	public const TYPE_INT = 'integer';
	public const TYPE_STRING = 'string';
	public const TYPE_NUMBER = 'number';
	public const TYPE_OBJECT = 'object';
	public const TYPE_NULL = 'null';

	public const IN_QUERY = 'query';
	public const IN_PATH = 'path';
	public const IN_FORM = 'form';
	public const IN_BODY = 'body';
	public const IN_HEADER = 'header';

	private string $namespace;

	function __construct ($namespace = 'rubicore/core/v1') {
		$this->namespace = $namespace;
	}

	private function route($callback, \WP_REST_Request $req) {
		header("Access-Control-Allow-Origin: *");
		header("Access-Control-Allow-Methods: POST, GET, OPTIONS, PUT, DELETE");
		header("Access-Control-Allow-Credentials: true");
		header('Access-Control-Allow-Headers: Origin, Content-Type, Accept, Authorization');
		header('Access-Control-Expose-Headers: Cache-Control, X-Pagination-Total');

		try {
			$token = Token_Helper::get_from_request($req);
			$user_id = Token_Helper::get_user_id($token);
			$user = new \WP_User($user_id);

			$data = $callback($req, $user);

			return new \WP_REST_Response($data, 200);
		} catch (\Exception $e) {
			$code = $e->getCode();
			$msg = $e->getMessage();

			return new \WP_Error('error', __($msg), array('status' => $code));
		}
	}


	public function add_route(string $url, string $method, $callback, $opts = array()): void {
		$schema = !isset($opts['schema']) ? null : $opts['schema'];
		$args = !isset($opts['args']) ? array() : $opts['args'];
		$auth = !isset($opts['auth_required']) ? true : $opts['auth_required'];
		$namespace = $this->namespace;

		$permission_callback = $auth ? function ($req) {
			$token_status = User_Helper::is_authorized($req);

			if($token_status['is_valid']){
				return true;
			}

			return new \WP_Error(401, __($token_status['msg']));
		} : '__return_true';


		add_action('rest_api_init', function () use($namespace, $url, $method, $callback, $args, $schema, $permission_callback) {

			// Add meta-data "in" to args
			$in_props = [];

			foreach($args as $key => $value) {
				if (array_key_exists('in', $value)) {
					$in_props[$key] = $value['in'];
				}
			}

			$args['_in'] = array(
				'type' => Api_Helper::TYPE_OBJECT,
				'properties' => $in_props
			);

			register_rest_route($namespace, $url, array(
				array(
					'methods' => [$method],
					'callback' => function (\WP_REST_Request $req) use($callback) {
						return $this->route($callback, $req);
					},
					'permission_callback' => $permission_callback,
					'args' => $args
				),
				'schema' => function () use($schema) {
					return $schema;
				}
			));
		});
	}
}
