<?php

namespace Rubicore\Core;

class Capability_Data {
	private array $list = array(
		// Post
		array('group' => 'post', 'key' => 'post_get', 'desc' => 'Hämta inlägg'),
		array('group' => 'post', 'key' => 'post_list', 'desc' => 'Lista inlägg'),
		array('group' => 'post', 'key' => 'post_delete', 'desc' => 'Ta bort inlägg'),
		array('group' => 'post', 'key' => 'post_edit', 'desc' => 'Uppdatera inlägg'),

		array('group' => 'post', 'key' => 'create_post', 'desc' => 'Skapa inlägg'),
		array('group' => 'post', 'key' => 'create_post_page', 'desc' => 'Skapa sida'),
		array('group' => 'post', 'key' => 'create_post_page_related', 'desc' => 'Skapa relaterad sida'),

		array('group' => 'post', 'key' => 'create_post_news', 'desc' => 'Skapa nyhet'),
		array('group' => 'post', 'key' => 'create_post_pinned_news', 'desc' => 'Skapa pinnad nyhet'),
		array('group' => 'post', 'key' => 'create_post_info', 'desc' => 'Skapa informationsmeddelande'),
		array('group' => 'post', 'key' => 'create_post_info_important', 'desc' => 'Skapa viktigt informationsmeddelande'),
		array('group' => 'post', 'key' => 'create_post_alert', 'desc' => 'Skapa krisinformation'),
		array('group' => 'post', 'key' => 'create_post_advertisment', 'desc' => 'Skapa Annons'),
		array('group' => 'post', 'key' => 'create_post_givetake', 'desc' => 'Skapa Ge & Ta'),
		array('group' => 'post', 'key' => 'create_post_course', 'desc' => 'Skapa Kurs'),
		array('group' => 'post', 'key' => 'create_post_child', 'desc' => 'Skapa barn'),

		// Comment
		array('group' => 'comment', 'key' => 'comment_list', 'desc' => 'List kommentarer'),
		array('group' => 'comment', 'key' => 'comment_get', 'desc' => 'Hämta kommentar'),
		array('group' => 'comment', 'key' => 'comment_create', 'desc' => 'Skapa kommentar'),
		array('group' => 'comment', 'key' => 'comment_delete', 'desc' => 'Ta bort kommentar'),

		// Course
		array('group' => 'course', 'key' => 'course_get', 'desc' => 'Hämta kurser'),
		array('group' => 'course', 'key' => 'course_list', 'desc' => 'Lista kurser'),
		array('group' => 'course', 'key' => 'course_add', 'desc' => 'Lägg till kurser'),
		array('group' => 'course', 'key' => 'course_delete', 'desc' => 'Ta bort kurser'),
		array('group' => 'course', 'key' => 'course_edit', 'desc' => 'Uppdatera kurser'),

		array('group' => 'course', 'key' => 'course_attendee_add', 'desc' => 'Lägg till kursmedlem'),
		array('group' => 'course', 'key' => 'course_attendee_update', 'desc' => 'Uppdatera kursmedlem'),
		array('group' => 'course', 'key' => 'course_attendee_remove', 'desc' => 'Ta bort kursmedlem'),

		// Like
		array('group' => 'like', 'key' => 'like_list', 'desc' => 'List likes'),
		array('group' => 'like', 'key' => 'like_get', 'desc' => 'Hämta like'),
		array('group' => 'like', 'key' => 'like_create', 'desc' => 'Skapa like'),
		array('group' => 'like', 'key' => 'like_delete', 'desc' => 'Ta bort like'),

		// Role
		array('group' => 'role', 'key' => 'role_get', 'desc' => 'Hämta roll'),
		array('group' => 'role', 'key' => 'role_list', 'desc' => 'Lista roller'),
		array('group' => 'role', 'key' => 'role_create', 'desc' => 'Skapa roll'),
		array('group' => 'role', 'key' => 'role_delete', 'desc' => 'Ta bort roll'),

		// Role Capability
		array('group' => 'role', 'key' => 'role_capability_add', 'desc' => 'Lägg till rättighet på roll'),
		array('group' => 'role', 'key' => 'role_capability_remove', 'desc' => 'Ta bort rättighet från roll'),

		// Capability
		array('group' => 'capability', 'key' => 'capability_list', 'desc' => 'Lista rättigheter'),

		// Link
		array('group' => 'links', 'key' => 'get_links', 'desc' => 'Hämta länkar'),
		array('group' => 'links', 'key' => 'search_links', 'desc' => 'Söka efter länkar'),
		array('group' => 'links', 'key' => 'delete_links', 'desc' => 'Ta bort länkar'),
		array('group' => 'links', 'key' => 'update_links', 'desc' => 'Uppdatera länkar'),
		array('group' => 'links', 'key' => 'post_links', 'desc' => 'Skapa länkar'),

		// User
		array('group' => 'user', 'key' => 'user_get', 'desc' => 'Hämta en användare'),
		array('group' => 'user', 'key' => 'user_list', 'desc' => 'Lista användare'),
		array('group' => 'user', 'key' => 'user_edit', 'desc' => 'Editera användare'),

		array('group' => 'user', 'key' => 'user_link_add', 'desc' => 'Lägg till länk på användare'),
		array('group' => 'user', 'key' => 'user_link_remove', 'desc' => 'Ta bort länk från användare'),
		array('group' => 'user', 'key' => 'user_link_sort', 'desc' => 'Sortera länkar för användare'),

		array('group' => 'user', 'key' => 'user_node_add', 'desc' => 'Lägg till node på användare'),
		array('group' => 'user', 'key' => 'user_node_remove', 'desc' => 'Ta bort node från användare'),

		array('group' => 'user', 'key' => 'user_category_add', 'desc' => 'Lägg till kategori på användare'),
		array('group' => 'user', 'key' => 'user_category_remove', 'desc' => 'Ta bort kategori från användare'),

		array('group' => 'user', 'key' => 'user_role_add', 'desc' => 'Lägg till roll på användare'),
		array('group' => 'user', 'key' => 'user_role_remove', 'desc' => 'Ta bort roll från användare'),

		array('group' => 'user', 'key' => 'user_capability_add', 'desc' => 'Sätt rättighet på användare'),
		array('group' => 'user', 'key' => 'user_capability_remove', 'desc' => 'Ta bort rättighet från användare'),

		// Token
		array('group' => 'token', 'key' => 'token_list', 'desc' => 'Lista tokens'),
		array('group' => 'token', 'key' => 'token_delete', 'desc' => 'Ta bort token'),
		array('group' => 'token', 'key' => 'token_create', 'desc' => 'Skapa token'),
		array('group' => 'token', 'key' => 'token_create_api', 'desc' => 'Skapa API token'),

		// Media
		array('group' => 'media', 'key' => 'media_list', 'desc' => 'Lista medias'),
		array('group' => 'media', 'key' => 'media_get', 'desc' => 'Hämta media'),
		array('group' => 'media', 'key' => 'media_create', 'desc' => 'Skapa media'),
		array('group' => 'media', 'key' => 'media_delete', 'desc' => 'Ta bort media')
	);

	public function get() : array {
		return apply_filters('rubicore_capability_list', $this->list);
	}
}
