<?php

namespace Rubicore\Core;

final class Category_Transformer {

	public static function transform_out($data) : Category_Model {
		$model = new Category_Model();

		$model->id = $data->id;
		$model->name = $data->name;
		$model->type = $data->type;
		$model->key = $data->category_key;

		return $model;
	}

	public static function transform_in(object $data) : Category_Entity {
		$model = new Category_Entity();

		$model->id = $data->id ?? null;
		$model->name = $data->name;
		$model->type = $data->type;
		$model->category_key = $data->key;

		return $model;
	}

}
