<?php

namespace Rubicore\Core;

use WP_Comment;

final class Comment_Repository
{
	private string $comment_table;

	function __construct()
	{
		$this->comment_table = Db_Helper::table('comments');
	}

	public function get_by_id(int $id): ?object
	{
		return Db_Helper::get_row("SELECT * FROM $this->comment_table AS c WHERE c.comment_ID = %d", [$id]);
	}

	public function get(\WP_REST_Request $req): array
	{
		$q = new Query_Builder_Helper($req, Comment_Query::$fields);
		$where = "";
		$where = Query_Helper::add_where($q->filter_query, $where, "AND", $q->filter_query);
		$where = Query_Helper::add_where($q->search_query, $where, "AND", $q->search_query);

		$count_query = Query_Helper::get_count("FROM $this->comment_table AS l $where");
		$total_count = Db_Helper::get_row($count_query)->num_rows;
		Response_Helper::set_pagination_total_header($total_count);

		$main_query = "SELECT * FROM $this->comment_table AS l $where $q->order_by_query $q->limit_query";

		return Db_Helper::get_rows($main_query);
	}

	public function create(int $post_id, int $user_id, string $content): ?int
	{
		$comment_data = array(
			'comment_post_ID' => $post_id,
			'user_id' => $user_id,
			'comment_content' => $content
		);

		return wp_insert_comment($comment_data);
	}


	public function update(int $comment_id, string $content): void
	{
		Db_Helper::update('comments', array(
			'comment_content' => $content
		), array(
			'comment_ID' => $comment_id
		), ['%s']);
	}

	public function delete(int $comment_id): void
	{
		wp_delete_comment($comment_id, true);
	}
}
