<?php

namespace Rubicore\Core;

final class Capability_Repository {

	public function get_for_user(int $user_id) : array {
		$user = new \WP_User($user_id);
		$capability_data = new Capability_Data();
		$caps = $capability_data->get();
		$user_caps = $user->allcaps;

		foreach ($caps as &$cap) {
			$cap['value'] = isset($user_caps[$cap['key']]) ? $user_caps[$cap['key']] : null;
		}

		return $caps;
	}

	private function get_for_role(string $key) : array {
		$role = get_role($key);

		if (!$role) {
			return [];
		}

		$capability_data = new Capability_Data();
		$caps = $capability_data->get();
		$role_caps = $role->capabilities;

		foreach ($caps as &$cap) {
			$cap['value'] = isset($role_caps[$cap['key']]) ? $role_caps[$cap['key']] : null;
		}

		return $caps;
	}

	public function get(array $filter) : array {
		if ($filter['role']) {
			return $this->get_for_role($filter['role']);
		}

		$capability_data = new Capability_Data();
		return $capability_data->get();
	}

	public function get_by_key(String $key): ?array {
		$capability_data = new Capability_Data();
		$caps =  $capability_data->get();

		$index = array_search($key, array_column($caps, 'key'));

		if ($index === false) {
			return null;
		}

		return $caps[$index];
	}

}
