<?php

namespace Rubicore\Core;

class Database_Installer {


	private static function create_table(string $name, string $body): void {
		global $wpdb;
		$table_name = Db_Helper::table($name);
		$charset_collate = $wpdb->get_charset_collate();

		$sql = "CREATE TABLE $table_name (
				$body
			) $charset_collate;";

		dbDelta($sql);
	}

	public static function create_tables() : void {
		require_once(ABSPATH . 'wp-admin/includes/upgrade.php');

		self::create_node_tables();
		self::create_post_tables();
		self::create_category_tables();
		self::create_user_tables();

		self::create_link_table();

		self::create_token_table();

		self::create_like_table();

		self::create_course_tables();
	}

	/**
	 *
	 * Table definitions
	 *
	 */

	private static function create_course_tables(): void
	{
		self::create_table('course_user', "
			id bigint(20) NOT NULL AUTO_INCREMENT,
			post_id bigint(20) NOT NULL,
			user_id bigint(20) NOT NULL,
			status varchar(55) DEFAULT '' NOT NULL,
			created datetime DEFAULT CURRENT_TIMESTAMP,
			information text DEFAULT '',
			KEY course_user_post_id (post_id),
			KEY course_user_user_id (user_id),
			UNIQUE (user_id, post_id),
			PRIMARY KEY  (id)
		");
	}

	 private static function create_node_tables(): void {
		self::create_table('node', "
			id bigint(20) NOT NULL AUTO_INCREMENT,
			name varchar(255) DEFAULT '',
			value varchar(255) DEFAULT '',
			ref varchar(255) DEFAULT '',
			parent bigint(20) DEFAULT NULL,
			PRIMARY KEY  (id)
		");
	}

	 private static function create_post_tables(): void {
		 self::create_table('post_node', "
			id bigint(20) NOT NULL AUTO_INCREMENT,
			node_id bigint(20) NOT NULL,
			post_id bigint(20) NOT NULL,
			KEY post_node_node_id (node_id),
			KEY post_node_post_id (post_id),
			UNIQUE (node_id, post_id),
			PRIMARY KEY  (id)
		");


		self::create_table('post_category', "
			id bigint(20) NOT NULL AUTO_INCREMENT,
			category_id bigint(20) NOT NULL,
			post_id bigint(20) NOT NULL,
			KEY post_category_category_id (category_id),
			KEY post_category_post_id (post_id),
			UNIQUE (category_id, post_id),
			PRIMARY KEY  (id)
		");

		self::create_table('post_user', "
			id bigint(20) NOT NULL AUTO_INCREMENT,
			post_id bigint(20) NOT NULL,
			user_id bigint(20) NOT NULL,
			KEY post_user_post_id (post_id),
			KEY post_user_user_id (user_id),
			UNIQUE (user_id, post_id),
			PRIMARY KEY  (id)
		");

		self::create_table('post_editor', "
			id bigint(20) NOT NULL AUTO_INCREMENT,
			post_id bigint(20) NOT NULL,
			user_id bigint(20) NOT NULL,
			type varchar(55) DEFAULT '' NOT NULL,
			KEY post_editor_post_id (post_id),
			KEY post_editor_user_id (user_id),
			KEY post_editor_type (type),
			UNIQUE (user_id, post_id, type),
			PRIMARY KEY  (id)
		");
	 }

	private static function create_category_tables(): void {
		self::create_table('category', "
			id bigint(20) NOT NULL AUTO_INCREMENT,
			name varchar(55) DEFAULT '' NOT NULL,
			type varchar(55) DEFAULT '' NOT NULL,
			category_key varchar(55) NOT NULL,
			UNIQUE (category_key),
			PRIMARY KEY  (id)
		");

		self::create_table('category_node', "
			id bigint(20) NOT NULL AUTO_INCREMENT,
			category_id bigint(20) NOT NULL,
			node_id bigint(20) NOT NULL,
			PRIMARY KEY  (id),
			UNIQUE (node_id, category_id),
			KEY category_node_category_id (category_id),
			KEY category_node_node_id (node_id)
		");
	}

	private static function create_user_tables(): void {
		self::create_table('user_node', "
			id bigint(20) NOT NULL AUTO_INCREMENT,
			node_id bigint(20) NOT NULL,
			user_id bigint(20) NOT NULL,
			main tinyint(1) DEFAULT 0 NOT NULL,
			KEY user_node_node_id (node_id),
			KEY user_node_user_id (user_id),
			UNIQUE (node_id, user_id),
			PRIMARY KEY  (id)
		");


		self::create_table('user_category', "
			id bigint(20) NOT NULL AUTO_INCREMENT,
			category_id bigint(20) NOT NULL,
			user_id bigint(20) NOT NULL,
			KEY user_category_category_id (category_id),
			KEY user_category_user_id (user_id),
			UNIQUE (category_id, user_id),
			PRIMARY KEY  (id)
		");


		self::create_table('user_link', "
			id bigint(20) NOT NULL AUTO_INCREMENT,
			user_id bigint(20) NOT NULL,
			link_id bigint(20) NOT NULL,
			sort bigint(20) DEFAULT 0 NOT NULL,
			disabled tinyint(1) DEFAULT 0 NOT NULL,
			KEY user_link_user_id (user_id),
			KEY user_link_link_id (link_id),
			UNIQUE (user_id, link_id),
			PRIMARY KEY  (id)
		");
	}

	private static function create_link_table(): void {
		self::create_table('link', "
			id bigint(20) NOT NULL AUTO_INCREMENT,
			created datetime DEFAULT CURRENT_TIMESTAMP,
			name tinytext DEFAULT '',
			type text DEFAULT '',
			short_description text DEFAULT '',
			long_description text DEFAULT '',
			icon tinytext DEFAULT '',
			url tinytext DEFAULT '',
			author bigint(20) DEFAULT NULL,
			public boolean DEFAULT true,
			PRIMARY KEY  (id)
		");

		self::create_table('link_node', "
			id bigint(20) NOT NULL AUTO_INCREMENT,
			node_id bigint(20) NOT NULL,
			link_id bigint(20) NOT NULL,
			KEY link_node_node_id (node_id),
			KEY link_node_link_id (link_id),
			UNIQUE (node_id, link_id),
			PRIMARY KEY  (id)
		");
	}

	public static function create_token_table() : void {
		self::create_table('token', "
			id bigint(20) NOT NULL AUTO_INCREMENT,
			user_id bigint(20) NOT NULL,
			token tinytext NOT NULL,
			expires bigint UNSIGNED NOT NULL,
			type varchar(55) DEFAULT '' NOT NULL,
			ref varchar(55) DEFAULT '' NOT NULL,
			created datetime DEFAULT CURRENT_TIMESTAMP,
			KEY token_user_id (user_id),
			KEY token_ref (ref),
			PRIMARY KEY  (id)
		");
	}


	public static function create_like_table(): void
	{
		self::create_table('like', "
			id bigint(20) NOT NULL AUTO_INCREMENT,
			post_id bigint(20) NOT NULL,
			user_id bigint(20) NOT NULL,
			type varchar(55) DEFAULT '' NOT NULL,
			created datetime DEFAULT CURRENT_TIMESTAMP,
			KEY like_user_id (user_id),
			KEY like_post_id (post_id),
			UNIQUE (post_id, user_id),
			PRIMARY KEY  (id)
		");
	}
}
