<?php

namespace Rubicore\Core;

class Role_Installer
{

	public function create_default_roles() : void
	{
		$capability_data = new Capability_Data();
		$role_repository = new Role_Repository();
		$all_roles = $role_repository->get();
		$all_caps = $capability_data->get();
		$caps_for_admin = [];

		foreach ($all_caps as $cap) {
			$caps_for_admin[$cap['key']] = true;
		}

		if (!$this->role_exists('rubicore-administrator', $all_roles)) {
			$this->create_role('rubicore-administrator', 'Rubicore Adminstrator', $caps_for_admin);
		}

		if (!$this->role_exists('rubicore-user', $all_roles)) {
			$this->create_role('rubicore-user', 'Rubicore User', [
				'post_get' => true,
				'post_list' => true,
				'comment_list' => true,
				'comment_get' => true,
				'comment_create' => true,
				'course_get' => true,
				'course_list' => true,
				'like_list' => true,
				'like_get' => true,
				'like_create' => true,
				'capability_list' => true,
				'get_links' => true,
				'search_links' => true,
				'user_get' => true,
				'user_link_add' => true,
				'token_create' => true,
				'media_list' => true,
				'media_get' => true,
				'media_create' => true
			]);
		}

		if (!$this->role_exists('rubicore-guest', $all_roles)) {
			$this->create_role('rubicore-guest', 'Rubicore Guest', []);
		}
	}

	private function role_exists(string $key, array $all_roles) : bool
	{
		$ret = false;

		foreach ($all_roles as $role) {
			if ($role->key == $key) {
				$ret = true;
				break;
			}
		}

		return $ret;
	}

	private function create_role(string $key, string $name, array $caps) : void
	{
		$role_repository = new Role_Repository();

		$role_repository->create($key, $name, $caps);
	}
}
