<?php

namespace Rubicore\Core;

final class Post_Media_Repository
{
	private string $post_media_table;
	private string $post_table;

	function __construct()
	{
		$this->post_media_table = Db_Helper::table('post_media');
		$this->post_table = Db_Helper::table('posts');
	}

	public function get_by_post_id(int $post_id) : array
	{
		return Db_Helper::get_rows("SELECT * FROM {$this->post_media_table} AS p WHERE p.post_id = %d", [$post_id]);
	}

	public function add(int $post_id, int $media_id): void
	{
		$mediaPost = Db_Helper::get_row("SELECT * FROM {$this->post_table} AS p WHERE p.id = %d AND p.post_type = 'media'", [$media_id]);

		if (!$mediaPost)
		{
			return;
		}

		Db_Helper::insert('post_media', array(
			'post_id' => $post_id,
			'media_id' => $media_id
		), ['%d', '%d', '%d']);
	}

	public function remove(int $post_id, int $media_id): void
	{
		Db_Helper::delete('post_media', array(
			'post_id' => $post_id,
			'media_id' => $media_id
		), ['%d', '%d']);
	}

	public function remove_all(int $post_id): void
	{
		Db_Helper::delete('post_media', array(
			'post_id' => $post_id
		), ['%d']);
	}
}
