<?php

namespace Rubicore\Core;

final class Media_Transformer {

	public static function transform_in(object $data) : Media_Entity {
		$entity = new Media_Entity();

		$entity->post_title = $data->title;
		$entity->post_content = $data->filename;
		$entity->post_excerpt = $data->description;
		$entity->post_author = $data->userId;
		$entity->post_mime_type = $data->mime_type;

		return $entity;
	}

	public static function transform_out(object $data) : Media_Model {
		$model = new Media_Model();

		$model->id = $data->ID;
		$model->filename = $data->post_content;
		$model->mimeType = $data->post_mime_type;
		$model->title = $data->post_title;
		$model->description = $data->post_excerpt;
		$model->publishedDate = $data->post_date;
		$model->author = isset($data->user) ? User_Transformer::transform_list_out($data->user) : null;

		return $model;
	}

}
